VERSION 5.00
Begin VB.Form frmMainForm 
   Caption         =   "GURPS: Space Star Creator"
   ClientHeight    =   3876
   ClientLeft      =   132
   ClientTop       =   588
   ClientWidth     =   6312
   LinkTopic       =   "Form1"
   ScaleHeight     =   3876
   ScaleWidth      =   6312
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame frmType 
      Caption         =   "Type of region:"
      Height          =   1212
      Left            =   1800
      TabIndex        =   23
      Top             =   840
      Width           =   1692
      Begin VB.OptionButton optCore 
         Caption         =   "Galactic Core"
         Height          =   204
         Left            =   120
         TabIndex        =   25
         TabStop         =   0   'False
         Top             =   840
         Width           =   1332
      End
      Begin VB.OptionButton optCluster 
         Caption         =   "Globular Cluster"
         Height          =   312
         Left            =   120
         TabIndex        =   24
         TabStop         =   0   'False
         Top             =   480
         Width           =   1452
      End
      Begin VB.OptionButton optSpiral 
         Caption         =   "Spiral Arm"
         Height          =   192
         Left            =   120
         TabIndex        =   5
         Top             =   240
         Value           =   -1  'True
         Width           =   1092
      End
   End
   Begin VB.OptionButton optFrequency7 
      Caption         =   "Rare (-3)"
      Height          =   192
      Left            =   3960
      TabIndex        =   21
      TabStop         =   0   'False
      Top             =   1920
      Width           =   2052
   End
   Begin VB.OptionButton optFrequency6 
      Caption         =   "Scarce (-2)"
      Height          =   192
      Left            =   3960
      TabIndex        =   20
      TabStop         =   0   'False
      Top             =   1680
      Width           =   2052
   End
   Begin VB.OptionButton optFrequency5 
      Caption         =   "Scarce (-1)"
      Height          =   192
      Left            =   3960
      TabIndex        =   19
      TabStop         =   0   'False
      Top             =   1440
      Width           =   2052
   End
   Begin VB.OptionButton optFrequency4 
      Caption         =   "Scattered (+0)"
      Height          =   192
      Left            =   3960
      TabIndex        =   6
      Top             =   1200
      Value           =   -1  'True
      Width           =   2052
   End
   Begin VB.OptionButton optFrequency3 
      Caption         =   "Likely (+1)"
      Height          =   192
      Left            =   3960
      TabIndex        =   18
      TabStop         =   0   'False
      Top             =   960
      Width           =   2052
   End
   Begin VB.OptionButton optFrequency2 
      Caption         =   "Likely (+2)"
      Height          =   192
      Left            =   3960
      TabIndex        =   17
      TabStop         =   0   'False
      Top             =   720
      Width           =   2052
   End
   Begin VB.OptionButton optFrequency1 
      Caption         =   "Common (+3)"
      Height          =   192
      Left            =   3960
      TabIndex        =   16
      TabStop         =   0   'False
      Top             =   480
      Width           =   2052
   End
   Begin VB.TextBox txtTechLevel 
      Alignment       =   2  'Center
      Height          =   288
      Left            =   600
      MaxLength       =   2
      TabIndex        =   4
      Text            =   "10"
      Top             =   3000
      Width           =   252
   End
   Begin VB.CheckBox chkScienceFantasy 
      Caption         =   "Include Science-Fantasy phenomena?"
      Height          =   432
      Left            =   3960
      TabIndex        =   8
      Top             =   2520
      Value           =   1  'Checked
      Width           =   2052
   End
   Begin VB.TextBox txtFileName 
      Height          =   288
      Left            =   1680
      TabIndex        =   7
      Text            =   "sector-001.txt"
      Top             =   2520
      Width           =   1812
   End
   Begin VB.CommandButton cmdQuit 
      Caption         =   "Quit"
      Height          =   372
      Left            =   4560
      TabIndex        =   9
      Top             =   3240
      Width           =   1092
   End
   Begin VB.CommandButton cmdGo 
      Caption         =   "Generate Stars"
      Height          =   372
      Left            =   2040
      TabIndex        =   0
      Top             =   3240
      Width           =   1572
   End
   Begin VB.TextBox txtHeight 
      Height          =   288
      Left            =   600
      MaxLength       =   3
      TabIndex        =   3
      Text            =   "10"
      Top             =   1800
      Width           =   612
   End
   Begin VB.TextBox txtWidth 
      Height          =   288
      Left            =   600
      MaxLength       =   3
      TabIndex        =   2
      Text            =   "10"
      Top             =   1320
      Width           =   612
   End
   Begin VB.TextBox txtLength 
      Height          =   288
      Left            =   600
      MaxLength       =   3
      TabIndex        =   1
      Text            =   "10"
      Top             =   840
      Width           =   612
   End
   Begin VB.Label lblFrequency 
      Caption         =   "Frequency of Habitable Worlds:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   7.8
         Charset         =   0
         Weight          =   400
         Underline       =   -1  'True
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   252
      Left            =   3960
      TabIndex        =   22
      Top             =   240
      Width           =   2772
   End
   Begin VB.Label lblHeight 
      Caption         =   "Z"
      Height          =   252
      Left            =   240
      TabIndex        =   15
      Top             =   1800
      Width           =   252
   End
   Begin VB.Label lblWidth 
      Caption         =   "Y"
      Height          =   252
      Left            =   240
      TabIndex        =   14
      Top             =   1320
      Width           =   252
   End
   Begin VB.Label lblLength 
      Caption         =   "X"
      Height          =   252
      Left            =   240
      TabIndex        =   13
      Top             =   840
      Width           =   252
   End
   Begin VB.Label lblFileName 
      Caption         =   "Output filename:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   7.8
         Charset         =   0
         Weight          =   400
         Underline       =   -1  'True
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   252
      Left            =   1680
      TabIndex        =   12
      Top             =   2280
      Width           =   1212
   End
   Begin VB.Label lblTechLevel 
      Alignment       =   2  'Center
      Caption         =   "Campaign's Tech Level:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   7.8
         Charset         =   0
         Weight          =   400
         Underline       =   -1  'True
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   372
      Left            =   240
      TabIndex        =   11
      Top             =   2520
      Width           =   972
   End
   Begin VB.Label lblSize 
      Caption         =   "Length, Width, Height, in Parsecs:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   7.8
         Charset         =   0
         Weight          =   400
         Underline       =   -1  'True
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   492
      Left            =   240
      TabIndex        =   10
      Top             =   240
      Width           =   1332
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuExitItem 
         Caption         =   "E&xit"
         Shortcut        =   ^X
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuAboutItem 
         Caption         =   "&About GSSC"
      End
   End
End
Attribute VB_Name = "frmMainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub Form_Load()
    Randomize
End Sub

Private Sub cmdGo_Click()

    Dim PlanetDiameter As Long
    
    Dim HabitableFrequency As Integer
    Dim CampaignTechLevel As Integer
    Dim TotalX As Integer
    Dim TotalY As Integer
    Dim TotalZ As Integer
    Dim LifeRollModifier As Integer
    Dim NumberMoonlets As Integer
    Dim NumberMoonsSmall As Integer
    Dim NumberMoonsMedium As Integer
    Dim NumberMoonsLarge As Integer
    Dim NumberMoonsGiant As Integer
    Dim NumberMoonsGas As Integer
    Dim Tester6 As Integer
    Dim DayLength As Integer
    Dim Tester7 As Integer
    Dim NumberGases As Integer
    Dim BioSphereDice As Integer
    Dim MineralRoll As Integer
    Dim NativeIQModifier As Integer
    Dim SocietyDice As Integer
    Dim EspionagePR As Integer
    Dim PatrolBasePR As Integer
    Dim RebelBasePR As Integer
    Dim SurveyBasePR As Integer
    
    Dim AtmosphereComposition As Byte
    Dim RegionType As Byte
    Dim Tester As Byte
    Dim Tester2 As Byte
    Dim Tester4 As Byte
    Dim Tester5 As Byte
    Dim NumberStars As Byte
    Dim StarClassTest As Byte
    Dim StarClassTest2 As Byte
    Dim StarClassTest3 As Byte
    Dim StarClass1 As Byte
    Dim StarClass2 As Byte
    Dim NumberOrbits As Byte
    Dim OortTest As Byte
    Dim PlanetNumber As Byte
    Dim GiantTypeRoll As Byte
    Dim GiantTypeRoll2 As Byte
    Dim NumberSpecialFeatures As Byte
    Dim SpecialFeatureRoll As Byte
    Dim PlanetTilt As Byte
    Dim AtmospherePressure As Byte
    Dim HighOxygenState As Byte
    Dim Tester8 As Byte
    Dim GasTypeNumber As Byte
    Dim GasTypeNumber2 As Byte
    Dim GasAmount As Byte
    Dim Tester9 As Byte
    Dim SurfaceWater As Byte
    Dim BioSphere As Byte
    Dim TerrainTypeDice As Byte
    Dim TerrainType As Byte
    Dim Humidity As Byte
    Dim Unusual As Byte
    Dim Unusual2 As Byte
    Dim NumberRaces As Byte
    Dim CurrentRace As Byte
    Dim NativeIntelligenceDice As Byte
    Dim PsychOdd As Byte
    Dim PsychOddDice As Byte
    Dim PhysicalOdd As Byte
    Dim PhysicalOddDice As Byte
    Dim NaturalEnvironment As Byte
    Dim NaturalEnvironment2 As Byte
    Dim NaturalEnvironmentDice As Byte
    Dim PopulationRating As Byte
    Dim TechLevelDice As Byte
    Dim TechLevel As Byte
    Dim MinimumCR As Byte
    Dim MaximumCR As Byte
    Dim CR As Byte
    Dim SocietyDice2 As Byte
    Dim SpecialCondition As Byte
    Dim EspionageType As Byte
    Dim ProductionTypeNumber As Byte
    Dim NumberProductionTypes As Byte
    Dim w As Byte
    
    Dim BodeD As Single
    Dim BodeB As Single
    Dim PlanetDensity As Single
    Dim PlanetGravity As Single
    Dim StellarMass As Single
    Dim StellarRadius As Single
    Dim YearLength As Single
    Dim BioZoneInner As Single
    Dim BioZoneOuter As Single
    Dim InnerLimit As Single
    
    Dim ScienceFantasy As Boolean
    Dim WhiteDwarf As Boolean
    Dim LivableMoon As Boolean
    Dim Human As Boolean
    Dim TechLevelArt As Boolean
    Dim TechLevelScience As Boolean
    Dim NoPrison As Boolean
    Dim EspionageTest As Boolean
    Dim GasChosen As Boolean
    
    Dim PlanetType(21) As Byte
    Dim GiantType(21) As Byte
    Dim GasType(2) As Byte
    Dim OrbitLocation(21) As Single
    Dim ProductionType(4) As Single
        
    FileName$ = txtFileName.Text

    If FileName$ = "" Then
        MsgBox ("Please enter a filename."), , "No FileName"
    Else
        MousePointer = vbHourglass

        Open FileName$ For Append As #1
        Print #1, "-----"
        Print #1, "GURPS: Space Star Creator"
        Print #1, "Generated on: " & Now
        Print #1, ""
            
        If (IsNumeric(txtLength.Text) = True) Then
            TotalX = txtLength.Text
            Select Case TotalX
            Case Is > 100
                TotalX = 100
            Case Is < 1
                TotalX = 1
            End Select
        Else
            TotalX = 1
        End If

        If (IsNumeric(txtWidth.Width) = True) Then
            TotalY = txtWidth.Text
            Select Case TotalY
            Case Is > 100
                TotalY = 100
            Case Is < 1
                TotalY = 1
            End Select
        Else
            TotalY = 1
        End If
        
        If (IsNumeric(txtHeight.Text) = True) Then
            TotalZ = txtHeight.Text
            Select Case TotalZ
            Case Is > 100
                TotalZ = 100
            Case Is < 1
                TotalZ = 1
            End Select
        Else
            TotalZ = 1
        End If
        
        If optFrequency1.Value = True Then
            HabitableFrequency = 3
        ElseIf optFrequency2.Value = True Then
            HabitableFrequency = 2
        ElseIf optFrequency3.Value = True Then
            HabitableFrequency = 1
        ElseIf optFrequency4.Value = True Then
            HabitableFrequency = 0
        ElseIf optFrequency5.Value = True Then
            HabitableFrequency = -1
        ElseIf optFrequency6.Value = True Then
            HabitableFrequency = -2
        Else
            HabitableFrequency = -3
        End If
        
        If optSpiral.Value = True Then
            RegionType = 0
        ElseIf optCore.Value = True Then
            RegionType = 1
        Else
            RegionType = 2
        End If
    
        ScienceFantasy = chkScienceFantasy.Value
        CampaignTechLevel = txtTechLevel.Text
        
        
        

        For i = 1 To TotalX
            For j = 1 To TotalY
                For k = 1 To TotalZ
                    
                    Tester = RollDie(6) + RollDie(6)
                    
                    If RegionType > 0 Then
                        Tester = Tester + 1
                    End If

                    Select Case Tester
                        Case 10
                            Tester2 = RollDie(6)
                            
                            If Tester2 = 6 Then
                                Print #1, "Coordinates: " & i & "," & j & "," & k
                                Unusual = RollDie(6) + RollDie(6) + RollDie(6)
                                
                                Select Case Unusual
                                    Case 3
                                        Print #1, "Unusual Stellar Object: Neutron star."
                                    Case 4
                                        Print #1, "Unusual Stellar Object: Black dwarf (no planets.)"
                                    Case 5
                                        Print #1, "Unusual Stellar Object: X-ray star."
                                    Case 6, 7
                                        Print #1, "Unusual Stellar Object: Brown dwarf, with planet-size moon(s)."
                                    Case 8, 9
                                        Print #1, "Unusual Stellar Object: Lost planet (gas giant)."
                                    Case 10 To 13
                                        Print #1, "Unusual Stellar Object: Lost planet (terrestrial)."
                                    Case 14
                                        Print #1, "Unusual Stellar Object: Flare star (red M-type)."
                                    Case 15
                                        Print #1, "Unusual Stellar Object: SS Cygni catastrophic variable."
                                        Print #1, " " & (RollDie(6) + RollDie(6)) & " months between bursts."
                                    Case 16
                                        Print #1, "Unusual Stellar Object: Center of nova shell."
                                    Case 17
                                        Print #1, "Unusual Stellar Object: Center of small dark nebula."
                                        Print #1, " Diameter: " & (RollDie(6)) & " parsecs."
                                    Case 18
                                        Print #1, "Very Unusual Stellar Object:"
                                        Print #1, " ";
                                        Unusual2 = RollDie(6) + RollDie(6) + RollDie(6)
                                        
                                        Select Case Unusual2
                                            Case 3
                                                Print #1, "Antimatter system."
                                            Case 4
                                                Print #1, "Planetary nebula."
                                                Print #1, " Diameter:" & (RollDie(6) / 10) & " parsecs."
                                            Case 5
                                                Print #1, "Pulsar."
                                            Case 6
                                                Print #1, "Center of dark nebula with T Tauri protostars condensing."
                                                Print #1, " Diameter: " & RollDie(6) & " parsecs."
                                                Print #1, " Number of Protostars: " & RollDie(6)
                                            Case 7
                                                Print #1, "Black dwarf, with planets."
                                            Case 8
                                                Print #1, "Center of large dark nebula."
                                                Print #1, " Diameter: " & (RollDie(6) + RollDie(6) + RollDie(6)) & " parsecs."
                                            Case 9, 10
                                                Print #1, "Black hole of average stellar mass."
                                            Case 11
                                                Print #1, "Nova."
                                            Case 12
                                                Print #1, "Black hole of 10 times average stellar mass."
                                            Case 13
                                                Print #1, "X-ray burster."
                                            Case 14, 15
                                                Print #1, "Natural wormhole to /somewhere/."
                                            Case 16
                                                Print #1, "Star enclosed by Dyson sphere. Star will be type F through M."
                                            Case 17
                                                Print #1, "Center of huge dark nebula."
                                                Print #1, " Diameter: " & RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6) & " parsecs."
                                            Case 18
                                                Print #1, "Neutron star/pulsar surrounded by supernova remnant."
                                        End Select
                                        
                                End Select
                                
                                Print #1, ""
                            End If
                            
                        Case Is > 10
                            'CreateStars
                            Print #1, "Coordinates: " & i & "," & j & "," & k
                            Print #1, "Star System:"

                            'Number of Stars
                            Tester2 = RollDie(6) + RollDie(6)
                            
                            If RegionType > 0 Then
                                Tester2 = Tester2 + 2
                            End If
                            
                            Select Case Tester2
                            Case 10
                                NumberStars = 2
                            Case 11
                                NumberStars = 3
                            Case 12
                                NumberStars = 4
                            Case Else
                                NumberStars = 1
                            End Select
                            
                            For l = 1 To NumberStars
                                If NumberStars > 1 Then
                                    Print #1, " Star #" & l & ": ";
                                Else
                                    Print #1, " ";
                                End If

                                StarClassTest = RollDie(6) + RollDie(6) + RollDie(6)
                                
                                If StarClassTest < 6 Then
                                    Print #1, "White dwarf (Class D). Previously was: ";
                                    WhiteDwarf = True
                                Else
                                    WhiteDwarf = False
                                End If
                                
                                Select Case StarClassTest
                                Case 6
                                    Print #1, "Subdwarf star (Class VI). ";
                                    StarClass1 = 6
                                    StarClassTest2 = RollDie(6)
                                    Select Case StarClassTest2
                                    Case 1
                                        Print #1, "G (Yellow)."
                                        StarClass2 = 5
                                    Case 2
                                        Print #1, "K (Orange)."
                                        StarClass2 = 6
                                    Case Else
                                        Print #1, "M (Red)."
                                        StarClass2 = 7
                                    End Select
                                Case Is < 18
                                    Print #1, "Main-sequence star (Class V). ";
                                    StarClass1 = 5
                                    StarClassTest2 = RollDie(6) + RollDie(6) + RollDie(6)
                                    Select Case StarClassTest2
                                    Case 3
                                        Print #1, "O (Blue)."
                                        StarClass2 = 1
                                    Case 4
                                        Print #1, "B (Blue-white)."
                                        StarClass2 = 2
                                    Case 5
                                        Print #1, "A (White)."
                                        StarClass2 = 3
                                    Case 6
                                        Print #1, "F (Yellow-white)."
                                        StarClass2 = 4
                                    Case 7
                                        Print #1, "G (Yellow)."
                                        StarClass2 = 5
                                    Case 8
                                        Print #1, "K (Orange)."
                                        StarClass2 = 6
                                    Case Else
                                        Print #1, "M (Red)."
                                        StarClass2 = 7
                                    End Select
                                Case Else
                                    StarClassTest2 = RollDie(6) + RollDie(6) + RollDie(6)
                                    Select Case StarClassTest2
                                    Case 3
                                        StarClassTest3 = RollDie(3)
                                        If StarClassTest3 = 1 Then
                                            Print #1, "Class Ia supergiant. ";
                                            StarClass1 = 0
                                        Else
                                            Print #1, "Class Ib supergiant. ";
                                            StarClass1 = 1
                                        End If
                                    Case 4
                                        Print #1, "Class II large giant. ";
                                        StarClass1 = 2
                                    Case Is < 13
                                        Print #1, "Class III giant. ";
                                        StarClass1 = 3
                                    Case Else
                                        Print #1, "Class IV subgiant. ";
                                        StarClass1 = 4
                                    End Select
                                    
                                    StarClass2 = 0
                                    Do
                                        StarClassTest3 = RollDie(6) + RollDie(6)
                                        Select Case StarClassTest3
                                        Case 2
                                            If (StarClass1 < 2) And (RegionType <> 1) Then
                                                Print #1, "O (Blue)."
                                                StarClass2 = 1
                                            End If
                                        Case 3
                                            If StarClass1 < 4 Then
                                                Print #1, "M (Red)."
                                                StarClass2 = 7
                                            End If
                                        Case Is < 6
                                            If (RegionType <> 1) Then
                                                Print #1, "B (Blue-white)."
                                                StarClass2 = 2
                                            End If
                                        Case Is < 10
                                            Print #1, "K (Orange)."
                                            StarClass2 = 6
                                        Case Else
                                            Print #1, "A (White)."
                                            StarClass2 = 3
                                        End Select
                                    Loop While StarClass2 = 0
                                    
                                End Select
                                
                                'Orbits, planets
                                
                                Select Case StarClass2
                                Case 1 ' O-type stars
                                    Select Case StarClass1
                                    Case 0
                                        StellarMass = 70
                                        BioZoneInner = 790
                                        BioZoneOuter = 1190
                                        InnerLimit = 16
                                        StellarRadius = 0.2
                                        NumberOrbits = 0
                                        LifeRollModifier = -12
                                    Case 1
                                        StellarMass = 60
                                        BioZoneInner = 630
                                        BioZoneOuter = 950
                                        InnerLimit = 13
                                        StellarRadius = 0.1
                                        NumberOrbits = 0
                                        LifeRollModifier = -12
                                    Case 5
                                        StellarMass = 50
                                        BioZoneInner = 500
                                        BioZoneOuter = 750
                                        InnerLimit = 10
                                        StellarRadius = 0
                                        NumberOrbits = 0
                                        LifeRollModifier = -9
                                    End Select
                                Case 2 ' B-type stars
                                    Select Case StarClass1
                                    Case 0
                                        StellarMass = 50
                                        BioZoneInner = 500
                                        BioZoneOuter = 750
                                        InnerLimit = 10
                                        StellarRadius = 0.2
                                        NumberOrbits = 0
                                        LifeRollModifier = -10
                                    Case 1
                                        StellarMass = 40
                                        BioZoneInner = 320
                                        BioZoneOuter = 480
                                        InnerLimit = 6.3
                                        StellarRadius = 0.1
                                        NumberOrbits = 0
                                        LifeRollModifier = -10
                                    Case 2
                                        StellarMass = 35
                                        BioZoneInner = 250
                                        BioZoneOuter = 375
                                        InnerLimit = 5
                                        StellarRadius = 0.1
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) = 3 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 3
                                        StellarMass = 30
                                        BioZoneInner = 200
                                        BioZoneOuter = 300
                                        InnerLimit = 4
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) = 3 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 4
                                        StellarMass = 20
                                        BioZoneInner = 180
                                        BioZoneOuter = 270
                                        InnerLimit = 3.8
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) = 3 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 5
                                        StellarMass = 10
                                        BioZoneInner = 30
                                        BioZoneOuter = 45
                                        InnerLimit = 0.6
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 5 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6))
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -9
                                    End Select
                                Case 3 ' A-type stars
                                    Select Case StarClass1
                                    Case 0
                                        StellarMass = 30
                                        BioZoneInner = 200
                                        BioZoneOuter = 300
                                        InnerLimit = 4
                                        StellarRadius = 0.6
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) = 3 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 3)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 1
                                        StellarMass = 16
                                        BioZoneInner = 50
                                        BioZoneOuter = 75
                                        InnerLimit = 1
                                        StellarRadius = 0.2
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) = 3 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 2)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 2
                                        StellarMass = 10
                                        BioZoneInner = 20
                                        BioZoneOuter = 30
                                        InnerLimit = 0.4
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) = 3 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 2)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 3
                                        StellarMass = 6
                                        BioZoneInner = 5
                                        BioZoneOuter = 7.5
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) = 3 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 4
                                        StellarMass = 4
                                        BioZoneInner = 4
                                        BioZoneOuter = 6
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 5 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6))
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 5
                                        StellarMass = 3
                                        BioZoneInner = 3.1
                                        BioZoneOuter = 4.7
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 6 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) - 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -9
                                    End Select
                                Case 4 ' F-type stars
                                    Select Case StarClass1
                                    Case 0
                                        StellarMass = 15
                                        BioZoneInner = 200
                                        BioZoneOuter = 300
                                        InnerLimit = 4
                                        StellarRadius = 0.8
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 5 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 3)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 1
                                        StellarMass = 13
                                        BioZoneInner = 50
                                        BioZoneOuter = 750
                                        InnerLimit = 1
                                        StellarRadius = 0.2
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 5 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 2)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 2
                                        StellarMass = 8
                                        BioZoneInner = 13
                                        BioZoneOuter = 19
                                        InnerLimit = 0.3
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 5 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -9
                                    Case 3
                                        StellarMass = 2.5
                                        BioZoneInner = 2.5
                                        BioZoneOuter = 3.7
                                        InnerLimit = 0.1
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 5 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6))
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -9
                                    Case 4
                                        StellarMass = 2.2
                                        BioZoneInner = 2
                                        BioZoneOuter = 3
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 7 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6))
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -9
                                    Case 5
                                        StellarMass = 1.9
                                        BioZoneInner = 1.6
                                        BioZoneOuter = 2.4
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 14 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) - 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -8
                                    End Select
                                Case 5 ' G-type stars
                                    Select Case StarClass1
                                    Case 0
                                        StellarMass = 12
                                        BioZoneInner = 160
                                        BioZoneOuter = 240
                                        InnerLimit = 3.1
                                        StellarRadius = 1.4
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 7 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 3)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 1
                                        StellarMass = 10
                                        BioZoneInner = 50
                                        BioZoneOuter = 75
                                        InnerLimit = 1
                                        StellarRadius = 0.4
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 7 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 2)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 2
                                        StellarMass = 6
                                        BioZoneInner = 13
                                        BioZoneOuter = 19
                                        InnerLimit = 0.3
                                        StellarRadius = 0.1
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 7 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -9
                                    Case 3
                                        StellarMass = 2.7
                                        BioZoneInner = 3.1
                                        BioZoneOuter = 4.7
                                        InnerLimit = 0.1
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 7 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6))
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -8
                                    Case 4
                                        StellarMass = 1.8
                                        BioZoneInner = 1
                                        BioZoneOuter = 1.5
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 8 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) - 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -6
                                    Case 5
                                        StellarMass = 1.1
                                        BioZoneInner = 0.8
                                        BioZoneOuter = 1.2
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) - 2)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = 0
                                    Case 6
                                        StellarMass = 0.8
                                        BioZoneInner = 0.5
                                        BioZoneOuter = 0.8
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = 1
                                    End Select
                                Case 6 ' K-type stars
                                    Select Case StarClass1
                                    Case 0
                                        StellarMass = 15
                                        BioZoneInner = 125
                                        BioZoneOuter = 190
                                        InnerLimit = 2.5
                                        StellarRadius = 3
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 11 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 2)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 1
                                        StellarMass = 12
                                        BioZoneInner = 50
                                        BioZoneOuter = 75
                                        InnerLimit = 1
                                        StellarRadius = 1
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 2)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 2
                                        StellarMass = 6
                                        BioZoneInner = 13
                                        BioZoneOuter = 19
                                        InnerLimit = 0.3
                                        StellarRadius = 0.2
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) + 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -9
                                    Case 3
                                        StellarMass = 3
                                        BioZoneInner = 4
                                        BioZoneOuter = 5.9
                                        InnerLimit = 0.1
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6))
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -7
                                    Case 4
                                        StellarMass = 2.3
                                        BioZoneInner = 1
                                        BioZoneOuter = 1.5
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) - 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -5
                                    Case 5
                                        StellarMass = 0.9
                                        BioZoneInner = 0.5
                                        BioZoneOuter = 0.6
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) - 2)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = 0
                                    Case 6
                                        StellarMass = 0.5
                                        BioZoneInner = 0.2
                                        BioZoneOuter = 0.3
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + 1)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = 1
                                    End Select
                                Case 7 ' M-type stars
                                    Select Case StarClass1
                                    Case 0
                                        StellarMass = 20
                                        BioZoneInner = 100
                                        BioZoneOuter = 150
                                        InnerLimit = 2
                                        StellarRadius = 7
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6))
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 1
                                        StellarMass = 16
                                        BioZoneInner = 50
                                        BioZoneOuter = 76
                                        InnerLimit = 1
                                        StellarRadius = 4.2
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6))
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -10
                                    Case 2
                                        StellarMass = 8
                                        BioZoneInner = 16
                                        BioZoneOuter = 24
                                        InnerLimit = 0.3
                                        StellarRadius = 1.1
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6))
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -9
                                    Case 3
                                        StellarMass = 4
                                        BioZoneInner = 5
                                        BioZoneOuter = 7.5
                                        InnerLimit = 0.1
                                        StellarRadius = 0.3
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6))
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = -6
                                    Case 5
                                        StellarMass = 0.3
                                        BioZoneInner = 0.1
                                        BioZoneOuter = 0.2
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + RollDie(6) - 2)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = 1
                                    Case 6
                                        StellarMass = 0.2
                                        BioZoneInner = 0.1
                                        BioZoneOuter = 0.1
                                        InnerLimit = 0
                                        StellarRadius = 0
                                        If (RollDie(6) + RollDie(6) + RollDie(6)) < 17 Then
                                            NumberOrbits = (RollDie(6) + RollDie(6) + 2)
                                        Else
                                            NumberOrbits = 0
                                        End If
                                        LifeRollModifier = 2
                                    End Select
                                End Select
                                
                                If WhiteDwarf = True Then
                                    StellarMass = 0.8
                                    BioZoneInner = 0.03
                                    BioZoneOuter = 0.03
                                    InnerLimit = 1
                                    StellarRadius = 0
                                    LifeRollModifier = -10
                                End If
                                
                                Print #1, "  Stellar Mass: " & StellarMass
                                
                                'Oort Cloud?
                                
                                OortTest = RollDie(6)
                                Print #1, "  Oort Cloud: ";
                                Select Case OortTest
                                Case Is < 5
                                    Print #1, "Normal."
                                Case 5
                                    Print #1, "Sparse."
                                Case Else
                                    Print #1, "None."
                                End Select
                                
                                'Planetary System
                                If NumberOrbits > 0 Then
                                    BodeD = (Int(RollDie(6))) / 10
                                    If (StarClass2 = 7) And (StarClass1 = 6) Then
                                        BodeB = 0.2
                                    Else
                                        Tester4 = RollDie(3)
                                        Select Case Tester4
                                        Case 1
                                            BodeB = 0.3
                                        Case 2
                                            BodeB = 0.35
                                        Case 3
                                            BodeB = 0.4
                                        End Select
                                    End If
                                End If

                                    'One planet at a time.
                                    For m = 1 To NumberOrbits
                                        
                                        If m = 1 Then
                                            OrbitLocation(m) = BodeD
                                        Else
                                            OrbitLocation(m) = BodeD + ((2 ^ (m - 2)) * BodeB)
                                        End If
                                        
                                        Select Case OrbitLocation(m)
                                        Case Is <= InnerLimit
                                            PlanetType(m) = 0
                                        Case Is < BioZoneInner
                                            Tester5 = RollDie(6) + RollDie(6)
                                            
                                            If NumberStars > 1 Then
                                                Tester5 = Tester5 - 2
                                            End If
                                            
                                            Select Case Tester5
                                            Case Is < 5
                                                PlanetType(m) = 0
                                            Case 5, 6
                                                PlanetType(m) = 1
                                            Case Is < 10
                                                PlanetType(m) = 2
                                            Case Is < 11
                                                PlanetType(m) = 3
                                            Case Else
                                            
                                                If m = 1 Then
                                                    PlanetType(m) = 0
                                                Else
                                                    PlanetType(m) = 4
                                                    GiantType(m) = 0
                                                    If (WhiteDwarf = True) And (OrbitLocation(m) <= 80) Then
                                                        PlanetType(m) = 7
                                                    End If
                                                    
                                                End If
                                                
                                            End Select
                                            
                                        Case Is > BioZoneOuter
                                            Tester5 = RollDie(6)
                                            
                                            If OrbitLocation(m) > (BioZoneOuter * 10) Then
                                                Tester5 = Tester5 + 1
                                            End If
                                            
                                            If NumberStars > 1 Then
                                                If Tester5 < 6 Then
                                                    Tester5 = 3
                                                Else
                                                    Tester5 = Tester5 - 2
                                                End If
                                            End If
                                            
                                            Select Case Tester5
                                            Case 1
                                                PlanetType(m) = 5
                                            Case 2
                                                PlanetType(m) = 3
                                            Case 3
                                                PlanetType(m) = 0
                                            Case Is < 7
                                            
                                                If (WhiteDwarf = True) And (OrbitLocation(m) <= 80) Then
                                                    PlanetType(m) = 7
                                                Else
                                                    PlanetType(m) = 6
                                                End If
                                                
                                            Case Else
                                                PlanetType(m) = 7
                                            End Select
                                            
                                        Case Else
                                            Tester5 = RollDie(6) + RollDie(6)
                                            
                                            If NumberStars > 1 Then
                                                Tester5 = Tester5 - 2
                                            End If
                                            
                                            Select Case Tester5
                                            Case Is < 4
                                                PlanetType(m) = 0
                                            Case Is < 9
                                                PlanetType(m) = 5
                                            Case Is < 11
                                                PlanetType(m) = 3
                                            Case Is < 12
                                            
                                                If (WhiteDwarf = True) And (OrbitLocation(m) <= 80) Then
                                                    PlanetType(m) = 7
                                                Else
                                                    PlanetType(m) = 8
                                                    GiantType(m) = 3
                                                End If
                                                
                                            Case Else
                                            
                                                If (WhiteDwarf = True) And (OrbitLocation(m) <= 80) Then
                                                    PlanetType(m) = 7
                                                Else
                                                    PlanetType(m) = 4
                                                End If
                                                
                                            End Select
                                            
                                        End Select
                                        
                                        If (WhiteDwarf = True) And (OrbitLocation(m) <= 40) Then
                                            If (PlanetType(m) > 0) And (PlanetType(m) <> 3) Then
                                                PlanetType(m) = 2
                                            End If
                                        End If
                                        
                                        'Gas Giants
                                        If PlanetType(m) = 6 Then
                                            GiantTypeRoll = RollDie(6) + RollDie(6) + RollDie(6)
                                                
                                            Select Case StarClass2
                                            Case 7
                                                GiantTypeRoll = GiantTypeRoll - 2
                                            Case 6
                                                GiantTypeRoll = GiantTypeRoll - 1
                                            End Select
                                                
                                            Select Case GiantTypeRoll
                                            Case Is > 12
                                                GiantType(m) = 3
                                            Case Is > 8
                                                GiantType(m) = 2
                                            Case Is > 4
                                                GiantType(m) = 1
                                            Case Else
                                                GiantTypeRoll2 = RollDie(6) + RollDie(6) + RollDie(6)
                                                    
                                                Select Case StarClass2
                                                Case 7
                                                    GiantTypeRoll2 = GiantTypeRoll2 - 2
                                                Case 6
                                                    GiantTypeRoll2 = GiantTypeRoll2 - 1
                                                End Select
                                                    
                                                Select Case GiantTypeRoll2
                                                Case Is > 12
                                                    GiantType(m) = 3
                                                Case Is > 8
                                                    GiantType(m) = 2
                                                Case Is > 4
                                                    GiantType(m) = 1
                                                Case 4
                                                    GiantType(m) = 0
                                                Case Else
                                                    NumberOrbits = m
                                                    If (m > 1) Then
                                                        For w = 1 To (m - 1)
                                                            PlanetType(w) = 0
                                                        Next w
                                                    End If
                                                    GiantType(m) = 0
                                                End Select
                                            End Select
                                        End If
                                    Next m
                                    
                                    PlanetNumber = 0
                                    For m = 1 To NumberOrbits
                                        
                                        LivableMoon = False
                                        
                                        If PlanetType(m) > 0 Then
                                        
                                            If (PlanetType(m) <> 3) Then
                                                PlanetNumber = PlanetNumber + 1
                                            End If
                                            
                                            Select Case PlanetType(m)
                                            Case 1
                                                Print #1, "  Planet #" & PlanetNumber
                                                Print #1, "   Distance from star: " & FormatNumber(OrbitLocation(m), 1, vbTrue, vbFalse, vbTrue) & " AU."
                                                Print #1, "   Greenhouse world."
                                            Case 2
                                                Print #1, "  Planet #" & PlanetNumber
                                                Print #1, "   Distance from star: " & FormatNumber(OrbitLocation(m), 1, vbTrue, vbFalse, vbTrue) & " AU."
                                                Print #1, "   Hot rockball world."
                                            Case 3
                                                Print #1, "  Asteroid belt."
                                                Print #1, "   Distance from star: " & FormatNumber(OrbitLocation(m), 1, vbTrue, vbFalse, vbTrue) & " AU."
                                            Case 4
                                                Print #1, "  Planet #" & PlanetNumber
                                                Print #1, "   Distance from star: " & FormatNumber(OrbitLocation(m), 1, vbTrue, vbFalse, vbTrue) & " AU."
                                                Print #1, "   Brown dwarf."
                                            Case 5
                                                Print #1, "  Planet #" & PlanetNumber
                                                Print #1, "   Distance from star: " & FormatNumber(OrbitLocation(m), 1, vbTrue, vbFalse, vbTrue) & " AU."
                                                Print #1, "   Terrestrial-type world."
                                            Case 6
                                                Print #1, "  Planet #" & PlanetNumber
                                                Print #1, "   Distance from star: " & FormatNumber(OrbitLocation(m), 1, vbTrue, vbFalse, vbTrue) & " AU."
                                                Print #1, "   Gas giant. ";
                                                Select Case GiantType(m)
                                                Case 3
                                                    Print #1, "Size: Large."
                                                Case 2
                                                    Print #1, "Size: Medium."
                                                Case 1
                                                    Print #1, "Size: Small."
                                                Case 0
                                                    Print #1, "Brown Dwarf."
                                                End Select
                                            Case 7
                                                Print #1, "  Planet #" & PlanetNumber
                                                Print #1, "   Distance from star: " & FormatNumber(OrbitLocation(m), 1, vbTrue, vbFalse, vbTrue) & " AU."
                                                Print #1, "   Terrestrial-type world."
                                            Case 8
                                                Print #1, "  Planet #" & PlanetNumber
                                                Print #1, "   Distance from star: " & FormatNumber(OrbitLocation(m), 1, vbTrue, vbFalse, vbTrue) & " AU."
                                                Print #1, "   Large gas giant."
                                            End Select
                                        End If
                                        
                                        If (PlanetType(m) = 4) Or (PlanetType(m) = 6) Or (PlanetType(m) = 8) Then
                                            
                                            'Moons
                                            NumberMoonlets = RollDie(6) + RollDie(6) + RollDie(6)
                                            Select Case GiantType(m)
                                            Case 0
                                                NumberMoonlets = NumberMoonlets + 2
                                            Case 3
                                                NumberMoonlets = NumberMoonlets + 1
                                            End Select
                                            
                                            NumberMoonsSmall = RollDie(6) + RollDie(6)
                                            Select Case GiantType(m)
                                            Case 0
                                                NumberMoonsSmall = NumberMoonsSmall + 2
                                            Case 3
                                                NumberMoonsSmall = NumberMoonsSmall + 1
                                            End Select
                                            
                                            NumberMoonsMedium = RollDie(6) + 1
                                            Select Case GiantType(m)
                                            Case 0
                                                NumberMoonsMedium = NumberMoonsMedium + 2
                                            Case 3
                                                NumberMoonsMedium = NumberMoonsMedium + 1
                                            End Select
                                            
                                            NumberMoonsLarge = RollDie(6) - 3
                                            Select Case GiantType(m)
                                            Case 0
                                                NumberMoonsLarge = NumberMoonsLarge + 2
                                            Case 3
                                                NumberMoonsLarge = NumberMoonsLarge + 1
                                            End Select
                                            
                                            NumberMoonsGiant = RollDie(6) - 5
                                            Select Case GiantType(m)
                                            Case 0
                                                NumberMoonsGiant = NumberMoonsGiant + 2
                                            Case 3
                                                NumberMoonsGiant = NumberMoonsGiant + 1
                                            End Select
                                            
                                            NumberMoonsGas = RollDie(6) - 7
                                            Select Case GiantType(m)
                                            Case 0
                                                NumberMoonsGas = NumberMoonsGas + 2
                                            Case 3
                                                NumberMoonsGas = NumberMoonsGas + 1
                                            End Select
                                            
                                            'Special Features for Gas Giants
                                            NumberSpecialFeatures = 0
                                            SpecialFeatureRoll = RollDie(6) + RollDie(6) + RollDie(6)
                                            Select Case GiantType(m)
                                            Case 0
                                                SpecialFeatureRoll = SpecialFeatureRoll + 3
                                            Case 3
                                                SpecialFeatureRoll = SpecialFeatureRoll + 2
                                            End Select
                                            
                                            If (SpecialFeatureRoll > 9) Then
                                                NumberSpecialFeatures = 1
                                                Do
                                                    Select Case SpecialFeatureRoll
                                                    Case 10
                                                        Print #1, "    Special Feature: One moon has a retrograde or inclined orbit."
                                                        NumberSpecialFeatures = NumberSpecialFeatures - 1
                                                    Case Is < 14
                                                        Print #1, "    Special Feature: Faint ring, like Uranus'."
                                                        NumberSpecialFeatures = NumberSpecialFeatures - 1
                                                    Case 14
                                                        Print #1, "    Special Feature: Spectacular ring, like Saturn's."
                                                        NumberSpecialFeatures = NumberSpecialFeatures - 1
                                                    Case 15
                                                        Print #1, "    Special Feature: 'Asteroid belt' of small moons and moonlets."
                                                        NumberSpecialFeatures = NumberSpecialFeatures - 1
                                                    Case 16
                                                        Print #1, "    Special Feature: 'Oort belt' of cometary slushballs."
                                                        NumberSpecialFeatures = NumberSpecialFeatures - 1
                                                    Case 17
                                                        NumberMoonlets = NumberMoonlets * 2
                                                        NumberMoonsSmall = NumberMoonsSmall * 2
                                                        NumberMoonsMedium = NumberMoonsMedium * 2
                                                        NumberMoonsLarge = NumberMoonsLarge * 2
                                                        NumberMoonsGiant = NumberMoonsGiant * 2
                                                        NumberMoonsGas = NumberMoonsGas * 2
                                                        NumberSpecialFeatures = NumberSpecialFeatures - 1
                                                    Case 18
                                                        NumberSpecialFeatures = NumberSpecialFeatures + 1
                                                    Case Else
                                                        Print #1, "    Special Feature: Produces enough heat to warm its moons; has at least one large or giant moon of habitable temperature."
                                                        LivableMoon = True
                                                        NumberSpecialFeatures = NumberSpecialFeatures - 1
                                                    End Select
                                                    
                                                    If (NumberSpecialFeatures > 0) Then
                                                        SpecialFeatureRoll = RollDie(6) + RollDie(6) + RollDie(6)
                                                        Select Case GiantType(m)
                                                        Case 0
                                                            SpecialFeatureRoll = SpecialFeatureRoll + 3
                                                        Case 3
                                                            SpecialFeatureRoll = SpecialFeatureRoll + 2
                                                        End Select
                                                    End If
                                                Loop Until (NumberSpecialFeatures = 0)
                                            End If
                                            
                                            If NumberMoonlets > 0 Then
                                                Print #1, "    " & NumberMoonlets & " Moonlets."
                                            End If
                                            If NumberMoonsSmall > 0 Then
                                                Print #1, "    " & NumberMoonsSmall & " Small Moons."
                                            End If
                                            If NumberMoonsMedium > 0 Then
                                                Print #1, "    " & NumberMoonsMedium & " Medium Moons."
                                            End If
                                            If NumberMoonsLarge > 0 Then
                                                Print #1, "    " & NumberMoonsLarge & " Large Moons."
                                            End If
                                            If NumberMoonsGiant > 0 Then
                                                Print #1, "    " & NumberMoonsGiant & " Giant Moons."
                                            End If
                                            If NumberMoonsGas > 0 Then
                                                Print #1, "    " & NumberMoonsGas & " Small Gas Giants."
                                            End If
                                        End If
                                        
                                        If (PlanetType(m) = 5) Or (PlanetType(m) = 7) Or (LivableMoon = True) Then ' Terrestrial planets
                                        
                                            PlanetDiameter = (RollDie(6) + RollDie(6)) * 1000
                                            
                                            If LivableMoon = True Then
                                                Print #1, "   Habitable Moon:"
                                                If PlanetDiameter < 2000 Then
                                                    PlanetDiameter = 2000
                                                End If
                                            End If
                                            
                                            PlanetDensity = ((RollDie(6) + RollDie(6) + RollDie(6)) / 10) + RollDie(6)
                                            PlanetGravity = PlanetDiameter * PlanetDensity * 0.0000228
                                            
                                            Tester6 = RollDie(6) + RollDie(6)
                                            Select Case Tester6
                                            Case Is < 4
                                                PlanetTilt = 0
                                            Case Is < 8
                                                PlanetTilt = (RollDie(6) * 3)
                                            Case Is < 11
                                                PlanetTilt = 20 + RollDie(6) + RollDie(6)
                                            Case 11
                                                PlanetTilt = 30 + RollDie(6) + RollDie(6) + RollDie(6)
                                            Case Else
                                                PlanetTilt = 40 + (RollDie(6) * 10)
                                                If PlanetTilt > 90 Then
                                                    PlanetTilt = 90
                                                End If
                                            End Select
                                            
                                            Print #1, "   Diameter: " & FormatNumber(PlanetDiameter, 0, vbTrue, vbFalse, vbTrue) & " miles."
                                            Print #1, "   Density: " & FormatNumber(PlanetDensity, 1, vbTrue, vbFalse, vbTrue) & "."
                                            Print #1, "   Gravity: " & FormatNumber(PlanetGravity, 2, vbTrue, vbFalse, vbTrue) & " Gs."
                                            Print #1, "   Axial Tilt: " & FormatNumber(PlanetTilt, 0, vbTrue, vbFalse, vbTrue) & " degrees."
                                            
                                            'Moons
                                            NumberMoonlets = RollDie(6) - 4
                                            Select Case PlanetDiameter
                                            Case Is < 8000
                                                NumberMoonlets = NumberMoonlets - 1
                                            Case Is > 12000
                                                NumberMoonlets = NumberMoonlets + 1
                                            End Select
                                            If NumberMoonlets < 0 Then
                                                NumberMoonlets = 0
                                            End If
                                            
                                            NumberMoonsSmall = RollDie(6) - 4
                                            Select Case PlanetDiameter
                                            Case Is < 8000
                                                NumberMoonsSmall = NumberMoonsSmall - 1
                                            Case Is > 12000
                                                NumberMoonsSmall = NumberMoonsSmall + 1
                                            End Select
                                            If NumberMoonsSmall < 0 Then
                                                NumberMoonsSmall = 0
                                            End If
                                            
                                            NumberMoonsMedium = RollDie(6) - 5
                                            Select Case PlanetDiameter
                                            Case Is < 8000
                                                NumberMoonsMedium = NumberMoonsMedium - 1
                                            Case Is > 12000
                                                NumberMoonsMedium = NumberMoonsMedium + 1
                                            End Select
                                            If NumberMoonsMedium < 0 Then
                                                NumberMoonsMedium = 0
                                            End If
                                            
                                            NumberMoonsLarge = RollDie(6) - 5
                                            Select Case PlanetDiameter
                                            Case Is < 8000
                                                NumberMoonsLarge = NumberMoonsLarge - 1
                                            Case Is > 12000
                                                NumberMoonsLarge = NumberMoonsLarge + 1
                                            End Select
                                            If NumberMoonsLarge < 0 Then
                                                NumberMoonsLarge = 0
                                            End If
                                            
                                            If NumberMoonlets > 0 Then
                                                Print #1, "    " & NumberMoonlets & " Moonlets."
                                            End If
                                            If NumberMoonsSmall > 0 Then
                                                Print #1, "    " & NumberMoonsSmall & " Small Moons."
                                            End If
                                            If NumberMoonMedium > 0 Then
                                                Print #1, "    " & NumberMoonsMedium & " Medium Moons."
                                            End If
                                            If NumberMoonLarge > 0 Then
                                                Print #1, "    " & NumberMoonLarge & " Large Moons."
                                            End If
                                            
                                            
                                            'Length of Day
                                            Tester6 = RollDie(6) + RollDie(6)
                                            
                                            Select Case m
                                            Case 1
                                                Tester6 = Tester6 - 4
                                            Case 2
                                                Tester6 = Tester6 - 2
                                            End Select
                                            
                                            If NumberMoonsLarge > 0 Then
                                                Tester6 = Tester6 - 1
                                            End If
                                            
                                            Select Case PlanetDiameter
                                            Case Is < 4000
                                                Tester6 = Tester6 - 1
                                            Case Is > 24000
                                                Tester6 = Tester6 + 1
                                            Case Is > 48000
                                                Tester6 = Tester6 + 2
                                            Case Is > 72000
                                                Tester6 = Tester6 + 3
                                            End Select
                                            
                                            Select Case Tester6
                                            Case Is < 3
                                                DayLength = (RollDie(6) + RollDie(6)) * 10 * 24
                                                Print #1, "   Length of Day: " & (DayLength / 24) & " Earth days."
                                            Case 3
                                                DayLength = RollDie(6) * 12 * 24
                                                Print #1, "   Length of Day: " & (DayLength / 24) & " Earth days."
                                            Case 4
                                                DayLength = RollDie(6) * 5 * 24
                                                Print #1, "   Length of Day: " & (DayLength / 24) & " Earth days."
                                            Case 5
                                                DayLength = (RollDie(6) + RollDie(6)) * 10
                                                Print #1, "   Length of Day: " & DayLength & " hours."
                                            Case 6
                                                DayLength = RollDie(6) * 10
                                                Print #1, "   Length of Day: " & DayLength & " hours."
                                            Case 7
                                                DayLength = RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6)
                                                Print #1, "   Length of Day: " & DayLength & " hours."
                                            Case 8
                                                DayLength = RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6)
                                                Print #1, "   Length of Day: " & DayLength & " hours."
                                            Case 9
                                                DayLength = RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6)
                                                Print #1, "   Length of Day: " & DayLength & " hours."
                                            Case 10
                                                DayLength = RollDie(6) + RollDie(6) + RollDie(6) + RollDie(6)
                                                Print #1, "   Length of Day: " & DayLength & " hours."
                                            Case Else
                                                DayLength = RollDie(6) + RollDie(6) + RollDie(6)
                                                Print #1, "   Length of Day: " & DayLength & " hours."
                                            End Select
                                            
                                            'Length of Year
                                            YearLength = Sqr((OrbitLocation(m) ^ 3) / StellarMass)
                                            Print #1, "   Length of Year: " & FormatNumber(YearLength, 2, vbTrue, vbFalse, vbTrue) & " Earth years."
                                            Print #1, "    (" & FormatNumber(((YearLength * 8766) / DayLength), 2, vbTrue, vbFalse, vbTrue) & " local days.)"
                                            
                                            'atmosphere density and type
                                            If (PlanetType(m) = 7) Then
                                                Tester7 = RollDie(2)
                                                
                                                If Tester7 = 1 Then
                                                    AtmospherePressure = 0
                                                Else
                                                    AtmospherePressure = 1
                                                End If
                                                
                                            Else
                                            
                                                Tester7 = RollDie(6) + RollDie(6)
                                                
                                                Select Case OrbitLocation(m)
                                                
                                                Case Is > (BioZoneOuter * 10)
                                                    Tester7 = Tester7 - 6
                                                Case Is > BioZoneOuter
                                                    Tester7 = Tester7 - 3
                                                End Select
                                                
                                                Select Case StarClass2
                                                Case 7
                                                    Tester7 = Tester7 - 2
                                                Case 6
                                                    Tester7 = Tester7 - 1
                                                End Select
                                                
                                                Tester7 = Tester7 + (Int(PlanetDiameter / 1600) - 5)
                                                
                                                Select Case Tester7
                                                Case Is < 4
                                                    AtmospherePressure = 0 'None
                                                Case 4
                                                    AtmospherePressure = 1 'Trace
                                                Case 5
                                                    AtmospherePressure = 2 'Very Thin.
                                                Case 6
                                                    AtmospherePressure = 3 'Thin
                                                Case Is < 10
                                                    AtmospherePressure = 4 'Standard
                                                Case 10
                                                    AtmospherePressure = 5 'Dense
                                                Case 11
                                                    AtmospherePressure = 6 'Very Dense
                                                Case Else
                                                    AtmospherePressure = 7 'SuperDense
                                                End Select
                                            End If
                                            
                                            If LivableMoon = True Then
                                                If AtmospherePressure = 0 Then
                                                    AtmospherePressure = 1
                                                End If
                                            End If
                                                
                                            Print #1, "   Atmosphere Pressure: ";
                                                
                                            Select Case AtmospherePressure
                                                Case 0
                                                    Print #1, "None."
                                                Case 1
                                                    Print #1, "Trace."
                                                Case 2
                                                    Print #1, "Very Thin."
                                                Case 3
                                                    Print #1, "Thin."
                                                Case 4
                                                    Print #1, "Standard."
                                                Case 5
                                                    Print #1, "Dense."
                                                Case 6
                                                    Print #1, "Very Dense."
                                                Case 7
                                                    Print #1, "Superdense."
                                            End Select
                                            
                                            If AtmospherePressure > 0 Then
                                                Tester8 = RollDie(6) + RollDie(6)
                                                
                                                If (Tester8 < 7) Or (AtmospherePressure = 7) Then
                                                    AtmosphereComposition = 0 ' Exotic
                                                    Print #1, "    Composition: Exotic."
                                                    NumberGases = RollDie(6) - 4
                                                    
                                                    If NumberGases < 1 Then
                                                        NumberGases = 1
                                                    End If
                                                        
                                                    GasAmount = (RollDie(6) * 10)
                                                    HighOxygenState = 0
                                                    
                                                    For q = 1 To NumberGases
                                                        GasChosen = False
                                                        GasType(q) = 0
                                                        
                                                        Do
                                                            GasTypeNumber = RollDie(6)
                                                            
                                                            Select Case OrbitLocation(m)
                                                            Case Is < BioZoneInner
                                                                GasTypeNumber = GasTypeNumber + 2
                                                            Case Is <= BioZoneOuter
                                                                GasTypeNumber = GasTypeNumber + 1
                                                            End Select
                                                            
                                                            Select Case GasTypeNumber
                                                            Case 1
                                                                If HighOxygenState < 2 Then
                                                                    'Hydrogen
                                                                    GasType(q) = 1
                                                                    GasChosen = True
                                                                    HighOxygenState = 1
                                                                End If
                                                            Case 2
                                                                If HighOxygenState < 2 Then
                                                                    'Methane
                                                                    GasType(q) = 2
                                                                    GasChosen = True
                                                                    HighOxygenState = 1
                                                                End If
                                                            Case 3
                                                                If HighOxygenState < 2 Then
                                                                    'Carbon oxides
                                                                    GasType(q) = 3
                                                                    GasChosen = True
                                                                    HighOxygenState = 1
                                                                End If
                                                            Case 4
                                                                'Corrosives
                                                                If NumberGases = 1 Then
                                                                    GasChosen = False
                                                                Else
                                                                    GasTypeNumber2 = RollDie(6)
                                                                    
                                                                    Select Case OrbitLocation(m)
                                                                    Case Is < BioZoneInner
                                                                        GasTypeNumber2 = GasTypeNumber + 2
                                                                    Case Is <= BioZoneOuter
                                                                        GasTypeNumber2 = GasTypeNumber + 1
                                                                    End Select
                                                                    
                                                                    Select Case GasTypeNumber2
                                                                    Case 1
                                                                        'Ammonia
                                                                        GasType(q) = 4
                                                                        GasChosen = True
                                                                    Case 2
                                                                        'Ammonia
                                                                        GasType(q) = 4
                                                                        GasChosen = True
                                                                    Case 3
                                                                        'Chlorine
                                                                        GasType(q) = 5
                                                                        GasChosen = True
                                                                    Case 4
                                                                        'Fluorine
                                                                        GasType(q) = 6
                                                                        GasChosen = True
                                                                    Case 5
                                                                        If HighOxygenState = 0 Then
                                                                            'High-Oxygen
                                                                            GasChosen = True
                                                                            HighOxygenState = 2
                                                                            GasType(q) = 7
                                                                            If q = 1 Then
                                                                                If GasAmount < 30 Then
                                                                                    GasAmount = 30
                                                                                End If
                                                                            End If
                                                                        End If
                                                                    Case 6
                                                                        'Nitrogen Oxides
                                                                        GasChosen = True
                                                                        GasType(q) = 8
                                                                    Case 7
                                                                        'Sulfur Compounds
                                                                        GasChosen = True
                                                                        GasType(q) = 9
                                                                    Case 8
                                                                        'Water Vapor
                                                                        GasChosen = True
                                                                        GasType(q) = 10
                                                                    End Select
                                                                
                                                                End If
                                                            Case Else
                                                                'Nitrogen
                                                                GasChosen = True
                                                                GasType(q) = 11
                                                            End Select
                                                            
                                                            If q = 2 Then
                                                                If GasType(2) = GasType(1) Then
                                                                    GasChosen = False
                                                                End If
                                                            End If
                                                        
                                                            If (GasChosen = True) Then
                                                            
                                                                Select Case GasType(q)
                                                                Case 1
                                                                    Print #1, "     Hydrogen (methane also present)";
                                                                Case 2
                                                                    Print #1, "     Methane (hydrogen also present)";
                                                                Case 3
                                                                    Print #1, "     Carbon oxides";
                                                                Case 4
                                                                    Print #1, "     Ammonia";
                                                                Case 5
                                                                    Print #1, "     Chlorine";
                                                                Case 6
                                                                    Print #1, "     Fluorine";
                                                                Case 7
                                                                    Print #1, "     High-Oxygen";
                                                                Case 8
                                                                    Print #1, "     Nitrogen Oxides";
                                                                Case 9
                                                                    Print #1, "     Sulfur Compounds";
                                                                Case 10
                                                                    Print #1, "     Water Vapor";
                                                                Case 11
                                                                    Print #1, "     Nitrogen";
                                                                End Select
                                                            
                                                                If (NumberGases > 1) Then
                                                                
                                                                    Select Case q
                                                                    Case 1
                                                                        Print #1, "; " & GasAmount & "%."
                                                                    Case 2
                                                                        Print #1, "; " & (100 - GasAmount) & "%."
                                                                    Case Else
                                                                        Print #1, "; Trace."
                                                                    End Select
                                                                    
                                                                Else
                                                                    Print #1, ""
                                                                End If
                                                                
                                                            End If
                                                        
                                                        Loop Until GasChosen = True
                                                        
                                                    Next q
                                                        
                                                ElseIf Tester8 < 10 Then
                                                    AtmosphereComposition = 1 ' Oxygen-Nitrogen
                                                    Print #1, "    Composition: Oxygen-Nitrogen."
                                                ElseIf Tester8 = 10 Then
                                                    AtmosphereComposition = 2 ' Polluted
                                                    Print #1, "    Composition: Polluted."
                                                Else
                                                    AtmosphereComposition = 3 ' Corrosive
                                                    Print #1, "    Composition: Corrosive."
                                                    NumberGases = RollDie(6) - 4
                                                    If NumberGases < 1 Then
                                                        NumberGases = 1
                                                    End If
                                                        
                                                    GasAmount = (RollDie(6) * 10)
                                                    
                                                    For q = 1 To NumberGases
                                                        
                                                        GasChosen = False
                                                        
                                                        Do
                                                            GasTypeNumber = RollDie(6)
                                                            GasType(q) = 0
                                                            
                                                            Select Case OrbitLocation(m)
                                                            Case Is < BioZoneInner
                                                                GasTypeNumber = GasTypeNumber + 2
                                                            Case Is <= BioZoneOuter
                                                                GasTypeNumber = GasTypeNumber + 1
                                                            End Select
                                                        
                                                            Select Case GasTypeNumber
                                                                Case 1
                                                                    'Ammonia
                                                                    GasType(q) = 4
                                                                    GasChosen = True
                                                                Case 2
                                                                    'Ammonia
                                                                    GasType(q) = 4
                                                                    GasChosen = True
                                                                Case 3
                                                                    'Chlorine
                                                                    GasType(q) = 5
                                                                    GasChosen = True
                                                                Case 4
                                                                    'Fluroine
                                                                    GasType(q) = 6
                                                                    GasChosen = True
                                                                Case 5
                                                                    'High-Oxygen
                                                                    GasType(q) = 7
                                                                    GasChosen = True
                                                                    If q = 1 Then
                                                                        If GasAmount < 30 Then
                                                                            GasAmount = 30
                                                                        End If
                                                                    End If
                                                                Case 6
                                                                    'Nitrogen Oxides
                                                                    GasType(q) = 8
                                                                    GasChosen = True
                                                                Case 7
                                                                    'Sulfur Compounds
                                                                    GasType(q) = 9
                                                                    GasChosen = True
                                                                Case 8
                                                                    'Water Vapor
                                                                    GasType(q) = 10
                                                                    GasChosen = True
                                                            End Select
                                                        
                                                            If q = 2 Then
                                                                If GasType(2) = GasType(1) Then
                                                                    GasChosen = False
                                                                End If
                                                            End If
                                                        
                                                        Loop Until GasChosen = True
                                                        
                                                        Select Case GasType(q)
                                                        Case 4
                                                            Print #1, "     Ammonia";
                                                        Case 5
                                                            Print #1, "     Chlorine";
                                                        Case 6
                                                            Print #1, "     Fluorine";
                                                        Case 7
                                                            Print #1, "     High-Oxygen";
                                                        Case 8
                                                            Print #1, "     Nitrogen Oxides";
                                                        Case 9
                                                            Print #1, "     Sulfur Compounds";
                                                        Case 10
                                                            Print #1, "     Water Vapor";
                                                        End Select
                                                        
                                                        If NumberGases > 1 Then
                                                            Select Case q
                                                            Case 1
                                                                Print #1, "; " & GasAmount & "%."
                                                            Case 2
                                                                Print #1, "; " & (100 - GasAmount) & "%."
                                                            Case Else
                                                                Print #1, "; Trace."
                                                            End Select
                                                        Else
                                                            Print #1, ""
                                                        End If
                                                        
                                                    Next q
                                                        
                                                End If
                                                
                                            End If
                                            
                                            'Climate
                                            If AtmospherePressure > 0 Then
                                                Tester9 = RollDie(6) + RollDie(6) + RollDie(6)
                                                
                                                If NumberStars > 1 Then
                                                    Tester9 = Tester9 - 1
                                                End If
                                                
                                                Select Case StarClass2
                                                Case 7
                                                    Tester9 = Tester9 + 2
                                                Case 6
                                                    Tester9 = Tester9 + 1
                                                End Select
                                                
                                                If LivableMoon = True Then
                                                    Tester9 = Tester9 + 3
                                                End If
                                                
                                                Print #1, "   Climate: ";
                                                Select Case Tester9
                                                Case Is < 6
                                                    Print #1, "Very Hot, avg 120F."
                                                Case Is < 8
                                                    Print #1, "Hot, avg 110F."
                                                Case 8
                                                    Print #1, "Tropical, avg 100F."
                                                Case 9
                                                    Print #1, "Warm, avg 90F."
                                                Case 10
                                                    Print #1, "Earth-normal, avg 80F"
                                                Case 11
                                                    Print #1, "Cool, avg 60F."
                                                Case 12
                                                    Print #1, "Chilly, avg 40F."
                                                Case 13
                                                    Print #1, "Cold, avg 20F."
                                                Case Is < 16
                                                    Print #1, "Very Cold, avg 0F."
                                                Case Else
                                                    Print #1, "Frozen, avg -20F."
                                                End Select
                                            End If
                                                
                                            'Surface Water
                                            SurfaceWater = 0
                                            If AtmospherePressure > 2 Then
                                                SurfaceWater = (RollDie(6) + RollDie(6) - 2) * 10
                                            End If
                                            
                                            'Biosphere
                                            If (AtmospherePressure > 0) And ((OrbitLocation(m) >= BioZoneInner) And (OrbitLocation(m) <= BioZoneOuter)) Or (LivableMoon = True) Then
                                                BioSphereDice = RollDie(6) + RollDie(6) + RollDie(6) + LifeRollModifier + HabitableFrequency
                                                Print #1, "   Biosphere: ";
                                                Select Case BioSphereDice
                                                Case Is < 8
                                                    Print #1, "No life."
                                                    BioSphere = 0
                                                Case 8, 9
                                                    Print #1, "Proto-organisms."
                                                    BioSphere = 1
                                                Case 10
                                                    Print #1, "Lower plants."
                                                    BioSphere = 2
                                                Case 11
                                                    Print #1, "Higher plants."
                                                    BioSphere = 3
                                                Case Is < 14
                                                    Print #1, "Lower animals (IQ 2-3)."
                                                    BioSphere = 4
                                                Case Is < 17
                                                    Print #1, "Higher animals (IQ 4-6)."
                                                    BioSphere = 5
                                                Case 17
                                                    Print #1, "Near-intelligence (IQ 7)."
                                                    BioSphere = 6
                                                Case Else
                                                    Print #1, "Intelligence (IQ 8+)."
                                                    BioSphere = 7
                                                

' Here we go...


NumberRaces = 1
CurrentRace = 1

Do

    Human = False
    PsychOdd = 0
    PhysicalOdd = 0
    
    If (OrbitLocation(m) >= BioZoneInner) And (OrbitLocation(m) <= BioZoneOuter) And (SurfaceWater >= 10) And _
        (AtmosphereComposition = 1) Or (AtmosphereComposition = 2) Then
            NativeIQModifier = -1
    ElseIf AtmosphereComposition <> 1 Then
        NativeIQModifier = 3
    Else
        NativeIQModifier = 0
    End If
    
    Do
        NativeIntelligenceDice = RollDie(6) + RollDie(6) + RollDie(6) + NativeIQModifier
        
        Select Case NativeIntelligenceDice
        Case 15
            NumberRaces = NumberRaces + 1
            NativeIntelligenceDice = 0
        Case 16
            PsychOdd = PsychOdd + 1
            NativeIQModifier = NativeIQModifier + 2
            NativeIntelligenceDice = 0
        Case Is > 16
            PhysicalOdd = PhysicalOdd + 1
        End Select
    
    Loop Until NativeIntelligenceDice > 0
    
    If NumberRaces > 1 Then
        If CurrentRace = 1 Then
            Print #1, "    Several races living in a symbiotic relationship..."
        End If
        Print #1, "    Native Intelligence #" & CurrentRace
    Else
        Print #1, "    Native Intelligence:"
    End If
    
    Select Case NativeIntelligenceDice
    Case Is < 5
        Print #1, "     Human colony (perhaps lost)."
        Human = True
    Case Is < 9
        Print #1, "     Cold-blooded, four limbs."
    Case 9
        Print #1, "     Cold-blooded, six limbs."
    Case 10
        Print #1, "     Warm-blooded, four limbs."
    Case 11
        Print #1, "     Warm-blooded, six limbs."
    Case 12
        Print #1, "     Insect- or crab-like."
    Case 13
        Print #1, "     Boneless or worm-like."
    Case 14
        Print #1, "     Plant-like."
    End Select
    
    If PhysicalOdd > 0 Then
        Do
            PhysicalOddDice = RollDie(6) + RollDie(6)
            Select Case PhysicalOddDice
            Case 2
                Print #1, "     Physical Oddity: Energy eater."
            Case 3
                Print #1, "     Physical Oddity: Energy eater."
            Case 4
                Print #1, "     Physical Oddity: Gaseous."
            Case 5
                Print #1, "     Physical Oddity: Shapeless."
            Case 6
                PhysicalOdd = PhysicalOdd + 2
            Case 7
                PsychOdd = PsychOdd + 1
                PhysicalOdd = PhysicalOdd + 1
            Case 8
                Print #1, "     Physical Oddity: Possess a sense humans don't have, such as radar."
            Case 9
                Print #1, "     Physical Oddity: This is an outpost; race is not native to the planet and is not adapted to it."
            Case 10
                Print #1, "     Physical Oddity: Artificial or mechanical life."
            Case 11
                Print #1, "     Physical Oddity: Silicon-based metabolism."
            Case 12
                Print #1, "     Physical Oddity: Silicon-based metabolism."
            End Select
            PhysicalOdd = PhysicalOdd - 1
        Loop While PhysicalOdd > 0
    End If
    
    If PsychOdd > 0 Then
        Do
            Print #1, "     Psychological Oddity: ";
            PsychOddDice = RollDie(6) + RollDie(6)
            Select Case PsychOddDice
            Case 2
                Print #1, "Simply incomprehensible to mankind."
            Case 3
                Print #1, "Simply incomprehensible to mankind."
            Case 4
                Print #1, "Hive culture (telepathic)."
            Case 5
                Print #1, "Hive culture (non-telepathic)."
            Case 6
                Print #1, "Dislikes other intelligent life."
            Case 7
                Print #1, "Extremely short life span."
            Case 8
                Print #1, "/Secretly/ xenophobic: dislikes other intelligent life."
            Case 9
                Print #1, "Ignores attempts to communicate."
            Case 10
                Print #1, "Secretive; avoids /all/ contact."
            Case 11
                Print #1, "Moves/thinks /very/ slowly."
            Case 12
                Print #1, "Moves/thinks /very/ slowly."
            End Select
            PsychOdd = PsychOdd - 1
        Loop While PsychOdd > 0
    End If
    
    If Human = False Then
        NaturalEnvironment = 0
        Do
            NaturalEnvironmentDice = RollDie(6) + RollDie(6)
            Select Case NaturalEnvironmentDice
            Case Is < 5
                If (SurfaceWater > 0) Then
                    Print #1, "     Natural Environment: Underwater."
                    NaturalEnvironment = 1
                End If
            Case Is < 7
                If (SurfaceWater > 0) Then
                    Print #1, "     Natural Environment: Water (surface)."
                    NaturalEnvironment = 2
                End If
            Case Is < 11
                If (SurfaceWater < 100) Then
                    Print #1, "     Natural Environment: Land."
                    NaturalEnvironment = 3
                End If
            Case 11
                If (SurfaceWater < 100) Then
                    Print #1, "     Natural Environment: Underground."
                    NaturalEnvironment = 4
                End If
            Case 12
                Print #1, "     Natural Environment: Air."
                NaturalEnvironment = 5
            End Select
        Loop Until (NaturalEnvironment > 0)
        
        If (NaturalEnvironment > 2) Then
            NaturalEnvironment2 = 0
            Print #1, "      Preferred Terrain Type: ";
            Do
                NaturalEnvironmentDice = RollDie(6) + RollDie(6)
                Select Case NaturalEnvironmentDice
                Case Is < 5
                    If AtmospherePressure > 2 Then
                        If SurfaceWater <= 30 Then
                            Print #1, "Desert/Barren."
                            NaturalEnvironment2 = 1
                        End If
                    Else
                        Print #1, "Icy/Barren."
                        NaturalEnvironment2 = 2
                    End If
                Case Is < 7
                    If SurfaceWater <= 70 Then
                        Print #1, "Hilly/Rough."
                        NaturalEnvironment2 = 3
                    End If
                Case 7
                    If SurfaceWater <= 30 Then
                        Print #1, "Mountainous/Volcanic."
                        NaturalEnvironment2 = 4
                    End If
                Case 8
                    If SurfaceWater <= 80 Then
                        Print #1, "Plains/Steppe."
                        NaturalEnvironment2 = 5
                    End If
                Case Is < 11
                    If SurfaceWater >= 40 Then
                        Print #1, "Forest/Jungle."
                        NaturalEnvironment2 = 6
                    End If
                Case Else
                    Print #1, "Marsh/Swamp."
                    NaturalEnvironment2 = 7
                End Select
            Loop Until (NaturalEnvironment2 > 0)
        End If
    End If
    CurrentRace = CurrentRace + 1
Loop Until (CurrentRace > NumberRaces)


'Population
PopulationRating = RollDie(6) + RollDie(6) - 2
Print #1, "    Population Rating: " & PopulationRating

' Tech levels.
TechLevelArt = False
TechLevelScience = False
TechLevelDice = RollDie(6) + RollDie(6) + RollDie(6)
Print #1, "    Tech Level: ";
Select Case TechLevelDice
Case 3
    TechLevel = (RollDie(6) + 1)
    Print #1, "Anomalous. " & TechLevel & ", but they have star travel."
Case Is < 6
    TechLevel = CampaignTechLevel
    Print #1, TechLevel & ", but retarded in a science: ";
    TechLevelScience = True
Case 6, 7
    TechLevel = CampaignTechLevel
    Print #1, TechLevel & ", but retarded in an art: ";
    TechLevelArt = True
Case 8, 9
    TechLevel = RollDie(6)
    Print #1, TechLevel & " (Primitive.)"
Case 10
    TechLevel = (CampaignTechLevel - RollDie(6))
    Print #1, TechLevel & " (Developing.)"
Case 11
    TechLevel = CampaignTechLevel
    Print #1, TechLevel & ", but slightly retarded."
Case 12
    TechLevel = CampaignTechLevel
    Print #1, TechLevel & " (Modern.)"
Case 13
    TechLevel = CampaignTechLevel
    Print #1, TechLevel & " (Slightly advanced.)"
Case Is < 17
    TechLevel = CampaignTechLevel
    Print #1, TechLevel & ", but advanced in an art: ";
    TechLevelArt = True
Case Else
    TechLevel = CampaignTechLevel
    Print #1, TechLevel & ", but advanced in a science: ";
    TechLevelScience = True
End Select
If (TechLevelArt = True) Then
    TechLevelDice = RollDie(6) + RollDie(6)
    Select Case TechLevelDice
    Case 2
        Print #1, "Games and diversions."
    Case 3
        Print #1, "Games and diversions."
    Case 4
        Print #1, "Social science or history."
    Case 5
        Print #1, "Mathematics."
    Case 6
        Print #1, "Visual arts."
    Case 7
        Print #1, "Finance and commerce."
    Case 8
        Print #1, "Performing arts."
    Case 9
        Print #1, "Music."
    Case 10
        Print #1, "Music."
    Case 11
        Print #1, "(Other arts.)"
    Case 12
        Print #1, "(Other arts.)"
    End Select
ElseIf (TechLevelScience = True) Then
    TechLevelDice = RollDie(6) + RollDie(6)
    Select Case TechLevelDice
    Case 2
        Print #1, "Biology and medicine."
    Case 3
        Print #1, "Biology and medicine."
    Case 4
        Print #1, "Biology and medicine."
    Case 5
        Print #1, "Weaponry."
    Case 6
        Print #1, "Sublight space travel."
    Case 7
        Print #1, "Power generation."
    Case 8
        Print #1, "Communications or sensors."
    Case 9
        Print #1, "Computers or robotics."
    Case 10
        Print #1, "Air or surface transportation."
    Case 11
        Print #1, "Air or surface transportation."
    Case 12
        Print #1, "FTL travel."
    End Select
End If

'Planetary Society
SocietyDice = RollDie(6) + RollDie(6)
MinimumCR = 0
MaximumCR = 6
If (TechLevel < 7) Then
    SocietyDice = SocietyDice - 4
End If
Select Case SocietyDice
Case Is < 6
    Print #1, "    No world government; diffuse."
Case 6
    Print #1, "    No world government; factionalized. ";
    Print #1, (RollDie(6) + RollDie(6) + RollDie(6)) & " major governments."
Case 7
    Print #1, "    No world government; coalition. ";
    Print #1, (RollDie(6)) & " major governments."
Case Else
    Print #1, "    World government. ";
    
    If TechLevel > 9 Then
        SocietyDice2 = (RollDie(6) + RollDie(6) + RollDie(6)) + 10
    Else
        SocietyDice2 = (RollDie(6) + RollDie(6) + RollDie(6)) + TechLevel
    End If
    
    Select Case SocietyDice2
    Case Is < 7
        Print #1, "Anarchy: no government!"
    Case Is < 9
        Print #1, "Clan/Tribal."
        MinimumCR = 3
        MaximumCR = 5
    Case Is < 11
        Print #1, "Caste."
        MinimumCR = 3
    Case 11
        Print #1, "Feudal."
        MinimumCR = 4
    Case 12
        Print #1, "Theocracy."
        MinimumCR = 3
    Case Is < 15
        Print #1, "Dictatorship."
        MinimumCR = 3
    Case Is < 18
        Print #1, "Representative Democracy."
        MinimumCR = 2
        MaximumCR = 4
    Case Is < 21
        Print #1, "Athenian Democracy."
        MinimumCR = 2
        MaximumCR = 4
    Case Is < 23
        Print #1, "Corporate State."
        MinimumCR = 4
    Case Is < 26
        Print #1, "Technocracy."
        MinimumCR = 3
    Case 26
        Print #1, "Caste."
        MinimumCR = 3
    Case Else
        Print #1, "Anarchy: no government!"
    End Select
    If (SocietyDice = 8) Then
        SpecialCondition = 1
        Do
            SocietyDice2 = (RollDie(6) + RollDie(6) + RollDie(6))
            Select Case SocietyDice2
            Case 3
                Print #1, "     Special Condition: Subjugated."
                MinimumCR = 4
                If (RollDie(2) = 1) Then
                    SpecialCondition = SpecialCondition + 1
                End If
            Case 4
                Print #1, "     Special Condition: Subjugated."
                MinimumCR = 4
                If (RollDie(2) = 1) Then
                    SpecialCondition = SpecialCondition + 1
                End If
            Case 5
                Print #1, "     Special Condition: Slave State."
            Case 6
                Print #1, "     Special Condition: Slave State."
            Case 7
                Print #1, "     Special Condition: Sanctuary."
            Case 8
                Print #1, "     Special Condition: Military Government."
                MinimumCR = 4
            Case 9
                Print #1, "     Special Condition: Socialist."
                If (RollDie(2) = 1) Then
                    SpecialCondition = SpecialCondition + 1
                End If
            Case 10
                Print #1, "     Special Condition: Bureaucracy."
                MinimumCR = 4
                If (RollDie(2) = 1) Then
                    SpecialCondition = SpecialCondition + 1
                End If
            Case 11
                Print #1, "     Special Condition: Colony."
            Case 12
                Print #1, "     Special Condition: Oligarchy."
                If MinimumCR < 3 Then
                    MinimumCR = 3
                End If
                If (RollDie(2) = 1) Then
                    SpecialCondition = SpecialCondition + 1
                End If
            Case 13
                Print #1, "     Special Condition: Restricted World: Hazardous."
                If (RollDie(2) = 1) Then
                    SpecialCondition = SpecialCondition + 1
                End If
            Case 14
                Print #1, "     Special Condition: Meritocracy."
                If MinimumCR < 3 Then
                    MinimumCR = 3
                End If
                If (RollDie(2) = 1) Then
                    SpecialCondition = SpecialCondition + 1
                End If
            Case 15
                Print #1, "     Special Condition: Restricted World: Embargoed."
                If (RollDie(2) = 1) Then
                    SpecialCondition = SpecialCondition + 1
                End If
            Case 16
                If (RollDie(2) = 1) Then
                    Print #1, "     Special Condition: Patriarchy."
                Else
                    Print #1, "     Special Condition: Matriarchy."
                End If
            Case 17
                Print #1, "     Special Condition: Utopia"
            Case 18
                If TechLevel < 8 Then
                    SpecialCondition = SpecialCondition + 1
                Else
                    Print #1, "     Special Condition: Cybercracy"
                    If MinimumCR < 3 Then
                        MinimumCR = 3
                    End If
                End If
            End Select
            SpecialCondition = SpecialCondition - 1
        Loop While (SpecialCondition > 0)
    End If
End Select

Do
    CR = RollDie(6)
Loop Until ((CR >= MinimumCR) And (CR <= MaximumCR))
Print #1, "     Control Rating: " & CR

'Starports
Print #1, "     Starport: Class ";
If (PopulationRating > 5) And ((RollDie(6) + RollDie(6) + RollDie(6)) < (PopulationRating + 3)) Then
    Print #1, "V - Full facilities."
ElseIf (PopulationRating > 5) And ((RollDie(6) + RollDie(6) + RollDie(6)) < (PopulationRating + 6)) Then
    Print #1, "IV - Standard facilities."
ElseIf ((RollDie(6) + RollDie(6) + RollDie(6)) < (PopulationRating + 9)) Then
    Print #1, "III - Local facilities."
ElseIf ((RollDie(6) + RollDie(6) + RollDie(6)) < (PopulationRating + 8)) Then
    Print #1, "II - Sub-C facilities."
ElseIf ((RollDie(6) + RollDie(6) + RollDie(6)) < 15) Then
    Print #1, "I - Emergency facilities."
Else
    Print #1, "0 - No facilities."
End If


'Installations
NoPrison = False

Print #1, "     Installations:"
If (RollDie(6) + RollDie(6) + RollDie(6)) <= 7 Then
    Print #1, "      Alien enclave."
    NoPrison = True
End If
If (RollDie(6) + RollDie(6) + RollDie(6)) <= (9 - CR) Then
    Print #1, "      Black market."
    NoPrison = True
End If
If (PopulationRating >= 3) Then
    If (RollDie(6) + RollDie(6) + RollDie(6)) <= (PopulationRating + 4) Then
        Print #1, "      Colonial office."
        NoPrison = True
    End If
End If
If (PopulationRating >= 6) And (TechLevel >= 7) Then
    If (RollDie(6) + RollDie(6) + RollDie(6)) <= (PopulationRating + 3) Then
        Print #1, "      Corporate headquarters."
        NoPrison = True
    End If
End If
If (RollDie(6) + RollDie(6) + RollDie(6)) <= (PopulationRating + 3) Then
    Print #1, "      Criminal base."
    NoPrison = True
End If


Do
    If (RollDie(6) + RollDie(6) + RollDie(6)) <= (TechLevel + PopulationRating) Then
        EspionageType = RollDie(6)
        Select Case EspionageType
        Case Is < 5
            EspionagePR = (RollDie(6) - 4)
            If EspionagePR >= 0 Then
                Print #1, "      Espionage facility. Civilian. Population Rating: " & EspionagePR
                EspionageTest = True
            Else
                EspionageTest = False
            End If
        Case 5
            EspionagePR = (RollDie(6) - 2)
            If EspionagePR >= 0 Then
                Print #1, "      Espionage facility. Friendly military. Population Rating: " & EspionagePR
                EspionageTest = True
            Else
                EspionageTest = False
            End If
        Case Else
            EspionagePR = (RollDie(6) - 2)
            If EspionagePR >= 0 Then
                Print #1, "      Espionage facility. Hostile military. Population Rating: " & EspionagePR
                EspionageTest = True
            Else
                EspionageTest = False
            End If
        End Select
    Else
        EspionageTest = False
    End If
Loop Until (EspionageTest = False)

If (RollDie(6) + RollDie(6) + RollDie(6)) <= 12 Then
    Print #1, "      Government research station.";
    If RollDie(3) = 1 Then
        Print #1, " (Secret.)"
    Else
        Print #1, " (Non-secret.)"
    End If
    If (RollDie(6) + RollDie(6) + RollDie(6)) <= 12 Then
        Print #1, "      Second government research station.";
        If RollDie(3) = 1 Then
            Print #1, " (Secret.)"
        Else
            Print #1, " (Non-secret.)"
        End If
    End If
    NoPrison = True
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= 7 Then
    Print #1, "      Mercenary base."
    NoPrison = True
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= (12 - PopulationRating) Then
    Print #1, "      Nature preserve."
    NoPrison = True
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= 10 Then
    Print #1, "      Naval base. Population Rating: " & (RollDie(6) - 1)
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= 9 Then
    PatrolBasePR = (RollDie(6) - 2)
    If (PatrolBasePR >= 0) Then
        Print #1, "      Patrol base. Population Rating: " & PatrolBasePR
    End If
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= (8 - CR) Then
    Print #1, "      Pirate base."
    NoPrison = True
End If

If (NoPrison = False) Then
    If (RollDie(6) + RollDie(6) + RollDie(6)) <= 8 Then
        Print #1, "      Pirate base."
    End If
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= (PopulationRating + 4) Then
    Print #1, "      Private research center."
    If (RollDie(6) + RollDie(6) + RollDie(6)) <= (PopulationRating + 4) Then
        Print #1, "      Second private research center."
        If (RollDie(6) + RollDie(6) + RollDie(6)) <= (PopulationRating + 4) Then
            Print #1, "      Third private research center."
        End If
    End If
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= 9 Then
    RebelBasePR = (RollDie(6) - 2)
    If (RebelBasePR >= 0) Then
        Print #1, "      Rebel or terrorist base. Population Rating: " & RebelBasePR
    End If
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= (PopulationRating - 3) Then
    Print #1, "      Refugee camp."
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= (PopulationRating - 3) Then
    Print #1, "      Religious center."
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= (PopulationRating - 6) Then
    Print #1, "      Special Justice Group office.";
    If RollDie(3) = 1 Then
        Print #1, " (Covert.)"
    Else
        Print #1, " (Not covert.)"
    End If
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= 9 Then
    SurveyBasePR = (RollDie(6) - 2)
    If (SurveyBasePR >= 0) Then
        Print #1, "      Survey base. Population Rating: " & SurveyBasePR
    End If
End If

If (RollDie(6) + RollDie(6) + RollDie(6)) <= (PopulationRating - 6) Then
    Print #1, "      University."
End If
        

'Production Type
ProductionTypeNumber = 1
ProductionType(0) = 0
'Mining
ProductionType(1) = 0
'Agricultural
ProductionType(2) = 0
'Industrial
ProductionType(3) = 0
'Service
ProductionType(4) = 0
'Government
NumberProductionTypes = 0

Do
    Select Case (RollDie(6) + RollDie(6))
    Case 2
        ProductionType(0) = ProductionType(0) + 1
    Case 3
        ProductionType(0) = ProductionType(0) + 1
    Case 4
        ProductionType(0) = ProductionType(0) + 1
    Case 6
        ProductionType(1) = ProductionType(1) + 1
    Case 7
        ProductionType(1) = ProductionType(1) + 1
    Case 8
        ProductionType(2) = ProductionType(2) + 1
    Case 9
        ProductionType(3) = ProductionType(3) + 1
    Case 10
        ProductionTypeNumber = ProductionTypeNumber + 2
    Case 11
        ProductionType(4) = ProductionType(4) + 1
    Case 12
        ProductionTypeNumber = ProductionTypeNumber + 3
    End Select
    ProductionTypeNumber = ProductionTypeNumber - 1
Loop Until (ProductionTypeNumber = 0)

ProductionTypeNumber = 0
Do
    If ProductionType(ProductionTypeNumber) > 0 Then
        NumberProductionTypes = NumberProductionTypes + 1
    End If
    ProductionTypeNumber = ProductionTypeNumber + 1
Loop Until ProductionTypeNumber > 4

If NumberProductionTypes = 1 Then
    Print #1, "     Production Type:";
Else
    Print #1, "     Production Types:";
End If

If NumberProductionTypes = 0 Then
    Print #1, " None."
Else
    ProductionTypeNumber = 0
    Do
    
        If ProductionType(ProductionTypeNumber) > 0 Then
        
            Select Case (ProductionTypeNumber)
            Case 0
                Print #1, " Mining";
            Case 1
                Print #1, " Agricultural";
            Case 2
                Print #1, " Industrial";
            Case 3
                Print #1, " Service";
            Case 4
                Print #1, " Government";
            End Select
        
            If ProductionType(ProductionTypeNumber) > 1 Then
                Print #1, " x" & ProductionType(ProductionTypeNumber);
            End If
        
            If NumberProductionTypes > 1 Then
                Print #1, ",";
                NumberProductionTypes = NumberProductionTypes - 1
            Else
                Print #1, "."
            End If
    
        End If

        ProductionTypeNumber = ProductionTypeNumber + 1
    Loop Until ProductionTypeNumber > 4

End If



                                                End Select
                                            End If
                                            
                                            'Terrain
                                            If AtmospherePressure > 0 Then
                                                Print #1, "   Primary Terrain Type: ";
                                                TerrainType = 0
                                                Do
                                                    TerrainTypeDice = RollDie(6) + RollDie(6)
                                                    Select Case TerrainTypeDice
                                                    Case Is < 5
                                                        If Tester9 < 12 Then
                                                            If SurfaceWater <= 30 Then
                                                                TerrainType = 1
                                                                Print #1, "Desert/Barren."
                                                            End If
                                                        Else
                                                            TerrainType = 2
                                                            Print #1, "Icy/Barren."
                                                        End If
                                                    Case Is < 7
                                                        If SurfaceWater <= 70 Then
                                                            TerrainType = 3
                                                            Print #1, "Hilly/Rough."
                                                        End If
                                                    Case 7
                                                        If SurfaceWater <= 30 Then
                                                            TerrainType = 4
                                                            Print #1, "Mountainous/Volcanic."
                                                        End If
                                                    Case 8
                                                        If SurfaceWater <= 80 Then
                                                            TerrainType = 5
                                                            Print #1, "Plains/Steppe."
                                                        End If
                                                    Case Is < 11
                                                        If BioSphere > 1 Then
                                                            If SurfaceWater >= 40 Then
                                                                TerrainType = 6
                                                                Print #1, "Forest/Jungle."
                                                            End If
                                                        End If
                                                    Case Else
                                                        TerrainType = 7
                                                        SurfaceWater = 70
                                                        Print #1, "Marsh/Swamp."
                                                    End Select
                                                Loop Until (TerrainType <> 0)
                                                Print #1, "   Surface Water: " & SurfaceWater & "%."
                                            End If
                                            
                                            'Humidity
                                            If AtmospherePressure > 0 Then
                                                Humidity = (SurfaceWater / 10) + (10 * (RollDie(6) + RollDie(6)))
                                                If Humidity > 100 Then
                                                    Humidity = 100
                                                End If
                                                If Humidity = 100 Then
                                                    Print #1, "   Humidity: 100%. (It rains all the time.)"
                                                Else
                                                    Print #1, "   Humidity: " & Humidity & "%."
                                                End If
                                            End If
                                            
                                            'Mineral Resources
                                            Print #1, "   Mineral Resources:"
                                            For n = 1 To 6
                                                MineralRoll = RollDie(6) + RollDie(6)
                                                
                                                Select Case n
                                                Case 1
                                                    Print #1, "    Gemstones/Industrial Crystals: ";
                                                    MineralRoll = MineralRoll - 3
                                                Case 2
                                                    Print #1, "    Rare/Special Minerals: ";
                                                    MineralRoll = MineralRoll - 2
                                                Case 3
                                                    Print #1, "    Radioactives: ";
                                                    MineralRoll = MineralRoll - 2
                                                Case 4
                                                    Print #1, "    Heavy Metals: ";
                                                    MineralRoll = MineralRoll - 1
                                                Case 5
                                                    Print #1, "    Industrial Metals: ";
                                                    MineralRoll = MineralRoll + 1
                                                Case 6
                                                    Print #1, "    Light Metals: ";
                                                    MineralRoll = MineralRoll + 3
                                                End Select
                                                
                                                Select Case PlanetDensity
                                                Case Is >= 7.1
                                                    MineralRoll = MineralRoll + 4
                                                Case Is >= 6.1
                                                    MineralRoll = MineralRoll + 2
                                                Case Is <= 3
                                                    MineralRoll = MineralRoll - 3
                                                Case Is <= 4.5
                                                    MineralRoll = MineralRoll - 1
                                                End Select
                                                
                                                Select Case SurfaceWater
                                                Case Is >= 90
                                                    MineralRoll = MineralRoll - 1
                                                Case Is <= 30
                                                    MineralRoll = MineralRoll + 1
                                                End Select
                                                
                                                Select Case MineralRoll
                                                Case Is < 7
                                                    Print #1, "Almost entirely absent."
                                                Case Is < 9
                                                    Print #1, "Scarce even for local use."
                                                Case 9
                                                    Print #1, "Ample for local use."
                                                Case Is < 12
                                                    Print #1, "Plentiful."
                                                Case Else
                                                    Print #1, "Extremely plentiful!"
                                                End Select
                                                
                                            Next n
                                            
                                            Print #1, "    Organics: ";
                                            MineralRoll = RollDie(6) + RollDie(6)
                                            Select Case MineralRoll
                                            Case Is < 7
                                                Print #1, "Almost entirely absent."
                                            Case Is < 9
                                                Print #1, "Scarce even for local use."
                                            Case 9
                                                Print #1, "Ample for local use."
                                            Case Is < 12
                                                Print #1, "Plentiful."
                                            Case Else
                                                Print #1, "Extremely plentiful!"
                                            End Select
                                            
                                        End If
                                        
                                Next m
                                
                            Next l
                            
                            'Unusual System Phenomena
                            Unusual = RollDie(6) + RollDie(6)
                            If Unusual = 12 Then
                                Print #1, "Unusual System Phenomena:"
                                Print #1, " ";
                                Unusual2 = RollDie(6) + RollDie(6) + RollDie(6)
                                
                                Select Case Unusual2
                                Case 3
                                
                                    If (ScienceFantasy = True) Then
                                        Print #1, "Sentient World."
                                    End If
                                    
                                Case 4
                                
                                    If (ScienceFantasy = True) Then
                                        Print #1, "Artificial world (TL14+)."
                                    End If
                                    
                                Case 5
                                
                                    If (ScienceFantasy = True) Then
                                        Print #1, "Artificial world (TL13)."
                                    End If
                                    
                                Case 6
                                    Print #1, "Double planet."
                                Case 7
                                    Print #1, "Elliptical-orbit world."
                                Case 8
                                    Print #1, "Captured world(s)."
                                Case 9
                                    Print #1, "Dead world(s)."
                                Case 10
                                    Print #1, "Unusually shaped world."
                                Case 11
                                    Print #1, "Eccentric star."
                                Case 12
                                    Print #1, "Inclined-orbit world."
                                Case 13
                                    Print #1, "Retrograde-revolution world."
                                Case 14
                                    Print #1, "Dying world."
                                Case 15
                                    Print #1, "Binary planet."
                                Case 16
                                
                                    If (ScienceFantasy = True) Then
                                        Print #1, "Ringworld."
                                    End If
                                    
                                Case 17
                                
                                    If (ScienceFantasy = True) Then
                                        Print #1, "Rosette."
                                    End If
                                    
                                Case 18
                                
                                    If (ScienceFantasy = True) Then
                                        Print #1, "Godstar."
                                    End If
                                    
                                End Select
                                
                            End If
                            
                            Print #1, ""
                    End Select
                    
                Next k
            Next j
        Next i

        Print #1, "-----"
        Close #1
        MousePointer = vbArrow
        MsgBox ("Generated!"), , "Generated"
    End If

End Sub

Private Sub mnuAboutItem_Click()
    ' show copyright and all that
    MsgBox ("GURPS is a trademark of Steve Jackson Games Incorporated, used" & _
    " by permission. All rights reserved. The GURPS game is copyright (c) 2001" & _
    " by Steve Jackson Games Incorporated. This program includes copyrighted" & _
    " material from the GURPS game, which is used by permission of Steve" & _
    " Jackson Games Incorporated. All rights reserved by Steve Jackson Games" & _
    " Incorporated."), , "About this program"
End Sub

Private Sub mnuExitItem_Click()
    End
End Sub

Private Sub cmdQuit_Click()
    End
End Sub

