using System;
using System.Collections.Generic;
using System.Text;

namespace ArkaneSystems.SJGames.FnorderLib
{
    public static class FnordMaker
    {
        static Random rand = new Random();

        /// <summary>
        /// Get a random selection from a word-list.
        /// </summary>
        internal static int GetRandomSelection(int length)
        {
            return rand.Next(length);
        }

        /// <summary>
        /// Decide if a particular chance has come up.
        /// </summary>
        internal static bool Perchance(int percentage)
        {
            return (rand.Next(100) < percentage);
        }

        /// <summary>
        /// Fnordmaker, fnordmaker, make me a fnord.
        /// </summary>
        public static string MakeFnord()
        {
            StringBuilder sb = new StringBuilder(256);

            // pick a syntax
            switch (rand.Next(14))
            {
                case 0:
                    // The
                    sb.Append("The ");
                    // <adjective> (50% chance)
                    if (Perchance(50))
                        sb.Append(WordLists.Adjective);
                    // <noun>
                    sb.Append(WordLists.Noun);
                    // in <someplace> (20% chance)
                    if (Perchance(20))
                    {   
                        sb.Append("in ");
                        sb.Append(WordLists.Place);
                    }
                    // is <adjective>
                    sb.Append("is ");
                    sb.Append(WordLists.Adjective);
                    break;

                case 1:
                    // <name> <action>
                    sb.Append(WordLists.Name);
                    // the <adjective> <noun>
                    sb.Append("the ");
                    sb.Append(WordLists.Adjective);
                    sb.Append(WordLists.Noun);
                    // and the <adjective> <noun>
                    sb.Append("and the ");
                    sb.Append(WordLists.Adjective);
                    sb.Append(WordLists.Noun);
                    break;

                case 2:
                    // The <noun>
                    sb.Append("The ");
                    sb.Append(WordLists.Noun);
                    // from <place>
                    sb.Append("from ");
                    sb.Append(WordLists.Place);
                    // will go to <place>
                    sb.Append("will go to ");
                    sb.Append(WordLists.Place);
                    break;

                case 3:
                    // <name>
                    sb.Append(WordLists.Name);
                    // must take the <adjective> <noun>
                    sb.Append("must take the ");
                    sb.Append(WordLists.Adjective);
                    sb.Append(WordLists.Noun);
                    // from <place>
                    sb.Append("from ");
                    sb.Append(WordLists.Place);
                    break;

                case 4:
                    // <place>
                    sb.Append(WordLists.Place);
                    // is <adjective>
                    sb.Append("is ");
                    sb.Append(WordLists.Adjective);
                    // and the <noun>
                    sb.Append("and the ");
                    sb.Append(WordLists.Noun);
                    // is <adjective>
                    sb.Append("is ");
                    sb.Append(WordLists.Adjective);
                    break;

                case 5:
                    // <name>
                    sb.Append(WordLists.Name);
                    // <preposition>
                    sb.Append(WordLists.Preposition);
                    // <place>
                    sb.Append(WordLists.Place);
                    // for the <adjective>
                    sb.Append("for the ");
                    sb.Append(WordLists.Adjective);
                    // <noun>
                    sb.Append(WordLists.Noun);
                    break;

                case 6:
                    // The
                    sb.Append("The ");
                    // <adjective> (50% chance)
                    if (Perchance(50))
                        sb.Append(WordLists.Adjective);
                    // <noun> <action>
                    sb.Append(WordLists.Noun);
                    sb.Append(WordLists.Action);
                    // the <adjective> <noun>
                    sb.Append("the ");
                    sb.Append(WordLists.Adjective);
                    sb.Append(WordLists.Noun);
                    // in <place> (20% chance)
                    if (Perchance(20))
                    {
                        sb.Append("in ");
                        sb.Append(WordLists.Place);
                    }
                    break;

                case 7:
                    // <name> <preposition> <place>
                    sb.Append(WordLists.Name);
                    sb.Append(WordLists.Preposition);
                    sb.Append(WordLists.Place);
                    // and <action>
                    sb.Append("and ");
                    sb.Append(WordLists.Action);
                    // the <noun>
                    sb.Append("the ");
                    sb.Append(WordLists.Noun);
                    break;

                case 8:
                    // <name>
                    sb.Append(WordLists.Name);
                    // takes <pronoun>
                    sb.Append("takes ");
                    sb.Append(WordLists.Pronoun);
                    // <adjective> (50% chance)
                    if (Perchance(50))
                        sb.Append(WordLists.Adjective);
                    // <noun>
                    sb.Append(WordLists.Noun);
                    // and <preposition> <place>
                    sb.Append("and ");
                    sb.Append(WordLists.Preposition);
                    sb.Append(WordLists.Place);
                    break;

                case 9:
                    // <name> <action>
                    sb.Append(WordLists.Name);
                    sb.Append(WordLists.Action);
                    // the
                    sb.Append("the ");
                    // <adjective> (50% chance)
                    if (Perchance(50))
                        sb.Append(WordLists.Adjective);
                    // <noun>
                    sb.Append(WordLists.Noun);
                    break;

                case 10:
                    // <name> <action> <name>
                    sb.Append(WordLists.Name);
                    sb.Append(WordLists.Action);
                    sb.Append(WordLists.Name);
                    // and <pronoun>
                    sb.Append("and ");
                    // <adjective> (50% chance)
                    if (Perchance(50))
                        sb.Append(WordLists.Adjective);
                    // <noun>
                    sb.Append(WordLists.Noun);
                    break;

                case 11:
                    // <name>
                    sb.Append(WordLists.Name);
                    // is the
                    sb.Append("is the ");
                    // <adjective> (50% chance)
                    if (Perchance(50))
                        sb.Append(WordLists.Adjective);
                    // <noun>
                    sb.Append(WordLists.Noun);
                    // ; to replace final space
                    sb[sb.Length - 1] = ';';
                    sb.Append(" ");
                    // <name> <preposition> <place>
                    sb.Append(WordLists.Name);
                    sb.Append(WordLists.Preposition);
                    sb.Append(WordLists.Place);
                    break;

                case 12:
                    // You must meet <name>
                    sb.Append("You must meet ");
                    sb.Append(WordLists.Name);
                    // at <place>
                    sb.Append("at ");
                    sb.Append(WordLists.Place);
                    // and get the
                    sb.Append("and get the ");
                    // <adjective> (50% chance)
                    if (Perchance(50))
                        sb.Append(WordLists.Adjective);
                    // <noun>
                    sb.Append(WordLists.Noun);
                    break;

                case 13:
                    // A <noun>
                    sb.Append("A ");
                    sb.Append(WordLists.Noun);
                    // from <place> <action>
                    sb.Append("from ");
                    sb.Append(WordLists.Place);
                    sb.Append(WordLists.Action);
                    // the
                    sb.Append("the ");
                    // <adjective> (50% chance)
                    if (Perchance(50))
                        sb.Append(WordLists.Adjective);
                    // <adjective> (20% chance)
                    if (Perchance(20))
                        sb.Append(WordLists.Adjective);
                    // <noun>
                    sb.Append(WordLists.Noun);
                    break;

                default:
                    throw new InvalidOperationException("Cannot happen. Fnord.");
            }

            sb.Length--;
            sb.Append(".");
            sb[0] = (sb[0].ToString().ToUpper())[0];
            return sb.ToString();
        }
    }
}
