//////////////////////////////////////////////////////////////////////////
// The Fnord Program
//
// Copyright 1997 by Steve Jackson Games (http://www.sjgames.com/). 
//
// All Rights Reserved.
//
// Please read the README file for configuration and licensing info.
//
// The Fnorder was originally written for the Illuminati BBS by Steve
// Jackson and Creede Lambard.  It was later reimplemented in C by 
// Loyd Blankenship, to perl by Jackie Hamilton, and finally converted
// to Java by Jim Lesko.
//////////////////////////////////////////////////////////////////////////

package com.sjgames.fnorder;

import java.util.Random;


/**
 *  Fnord program that creates illuminating statements through the
 *  pseudo-random recombination of important words and phrases.
 *<P>
 *  To get fnord text, simply call this class from the command line or
 *  call Fnorder.getFnord ().
 */
public class Fnorder implements Fnorders
{
   static protected Random  rand;

   private Fnorder ()
   {
      // cannot instantiate this class
   }

   /**
    *  Prints a fnord to stdout.
    */
   static public void main (String[] args)
   {
      System.out.println (getFnord ());
   }
   
   
   /**
    *  Returns an introductory word/phrase.
    */
   static protected String getIntro ()
   {
      return (intros [rand (intros.length)]);
   }
   
   
   /** 
    *  Returns a noun.
    */
   static protected String getNoun ()
   {
      return (nouns[rand (nouns.length)]);
   }
   
   
   /**
    *  Returns a proper name.
    */
   static protected String getName ()
   {
      return (names[rand (names.length)]);
   }
   
   
   /**
    *  Returns the name of a place.
    */
   static protected String getPlace ()
   {
      return (places[rand (places.length)]);
   }
   
   
   /**
    *  Returns a person's name.
    */
   static protected String getPrs ()
   {
      return (prepositions[rand (prepositions.length)]);
   }
   
   
   /**
    *  Returns an action oriented word/phrase.
    */
   static protected String getAct ()
   {
      return (actions[rand (actions.length)]);
   }
   
   
   /**
    *  Returns a pronoun.
    */
   static protected String getPronoun ()
   {
      return (pronouns[rand (pronouns.length)]);
   }
   
   
   /**
    *  Returns an adjective.
    */
   static protected String getAdj ()
   {
      return (adjectives[rand (adjectives.length)]);
   }
   
   
   /**
    *  Returns a random number between 0 and max - 1.
    */
   static protected int rand (int max)
   {
      if (rand == null)
         rand = new Random (System.currentTimeMillis ());
      
      return ((int) (rand.nextDouble () * max));
   }
   
   
   /**
    *  Returns a randomly created fnord.
    */
   static public String getFnord ()
   {
      int          syntax = rand (14);
      StringBuffer msg = new StringBuffer ();
      String       finalMsg;
     
      // GRAMMAR RULES:
      // -----------------------------------
      if (syntax == 0) 
      {
         msg.append ("The ");             // The
         if (rand (2) > 0) 
         {                                // <adjective>  (50% chance)
            msg.append (getAdj());
         }
         
         msg.append (getNoun());          // <noun>
         
         if (rand (5) == 0) 
         {                                // in <someplace>   (20% chance)
            msg.append ("in ");
            msg.append (getPlace());
         }
         
         msg.append ("is ");              // is
         msg.append (getAdj());           // <adjective>
      }
      else if (syntax == 1) 
      {
         msg.append (getName());          // <name>
         msg.append (getAct());           // <action>
         msg.append ("the ");             // the
         msg.append (getAdj());           // <adjective>
         msg.append (getNoun());          // <noun>
         msg.append ("and the ");         // and the
         msg.append (getAdj());           // <adjective>
         msg.append (getNoun());          // <noun>
      }
      else if (syntax == 2) 
      {
         msg.append ("The ");             // The
         msg.append (getNoun());          // <noun>
         msg.append ("from ");            // from
         msg.append (getPlace());         // <place>
         msg.append ("will go to ");      // will go to 
         msg.append (getPlace());         // <place>
      }
      else if (syntax == 3) 
      {
         msg.append (getName());          // <name>
         msg.append ("must take the ");   // must take the
         msg.append (getAdj());           // <adjective>
         msg.append (getNoun());          // <noun>
         msg.append ("from ");            // from
         msg.append (getPlace());         // <place>
      }
      else if (syntax == 4) 
      {
         msg.append (getPlace());         // <place>
         msg.append ("is ");              // is
         msg.append (getAdj());           // <adjective>
         msg.append ("and the ");         // and the
         msg.append (getNoun());          // <noun>
         msg.append ("is ");              // is
         msg.append (getAdj());           // <adjective>
      }
      else if (syntax == 5) 
      {
         msg.append (getName());          // <name>
         msg.append (getPrs());           // <preposition>
         msg.append (getPlace());         // <place>
         msg.append ("for the ");         // for the
         msg.append (getAdj());           // <adjective>
         msg.append (getNoun());          // <noun>
      }
      else if (syntax == 6) 
      {
         msg.append ("The ");             // The
         if (rand (2) > 0) 
         {
            msg.append (getAdj());        // <adjective> (50% chance)
         }
         msg.append (getNoun());          // <noun>
         msg.append (getAct());           // <action>
         msg.append ("the ");             // the
         msg.append (getAdj());           // <adjective>
         msg.append (getNoun());          // <noun>
         if (rand (5)==0) 
         {                                // in <place>  (20% chance)
            msg.append ("in ");
            msg.append (getPlace());
         }
      }
      else if (syntax == 7) 
      {
         msg.append (getName());          // <name>
         msg.append (getPrs());           // <preposition>
         msg.append (getPlace());         // <place>
         msg.append ("and ");             // and
         msg.append (getAct());           // <action>
         msg.append ("the ");             // the
         msg.append (getNoun());          // <noun>
      }
      else if (syntax == 8) 
      {
         msg.append (getName());          // <name>
         msg.append ("takes ");           // takes
         msg.append (getPronoun());       // <pronoun>
         if (rand (2) > 0) 
         {         
            msg.append (getAdj());        // <adjective> (50% chance)
         }
         msg.append (getNoun());          // <noun>
         msg.append ("and ");             // and
         msg.append (getPrs());           // <preposition>
         msg.append (getPlace());         // <place>
      }
      else if (syntax == 9) 
      {
         msg.append (getName());          // <name>
         msg.append (getAct());           // <action>
         msg.append ("the ");             // the
         if (rand (2) > 0) 
         {
            msg.append (getAdj());        // <adjective> (50% chance)
         }
         msg.append (getNoun());          // <noun>
      }
      else if (syntax == 10) 
      {
         msg.append (getName());          // <name>
         msg.append (getAct());           // <action>
         msg.append (getName());          // <name>
         msg.append ("and ");             // and
         msg.append (getPronoun());       // <pronoun>
         if (rand (2) > 0) 
         {
            msg.append (getAdj());        // <adjective> (50% chance)
         }
         msg.append (getNoun());          // <noun>
      }
      else if (syntax == 11) 
      {
         msg.append (getName());          // <name>
         msg.append ("is the ");          // is the
         if (rand (2) > 0) 
         {      
            msg.append (getAdj());        // <adjective> (50% chance)
         }          
         msg.append (getNoun());          // <noun>
         
         msg = new StringBuffer (msg.toString ().trim ());
         
         msg.append ("; ");               // ;
         msg.append (getName());          // <name>
         msg.append (getPrs());           // <preposition>
         msg.append (getPlace());         // <place>
      }
      else if (syntax == 12) 
      {
         msg.append ("You must meet ");   // You must meet
         msg.append (getName());          // <name>
         msg.append ("at ");              // at
         msg.append (getPlace());         // <place>
         msg.append ("and get the ");     // and get the
         if (rand (2) > 0) 
         {
            msg.append (getAdj());        // <adjective> (50% chance)
         }
         msg.append (getNoun());          // <noun>
      }
      else 
      {
         msg.append ("A ");               // A
         msg.append (getNoun());          // <noun>
         msg.append ("from ");            // from
         msg.append (getPlace());         // <place>
         msg.append (getAct());           // <action>
         msg.append ("the ");             // the
         if (rand (2) > 0) 
         {
            msg.append (getAdj());        // <adjective> (50% chance)
         }
         if (rand (5) == 0) 
         {
            msg.append (getAdj());        // <adjective> (20% chance)
         }
         msg.append (getNoun());          // <noun>
      }
      
      // capitalize:  
      finalMsg = msg.toString ().substring (0,1).toUpperCase () + 
         msg.toString ().substring (1); 
            
      finalMsg = finalMsg.trim ();        // delete the blank at the end
      
      finalMsg += ".";                    // add a period
      
      return (finalMsg);                  // return it
   }
   
   // the end.
}
