/*

 The Fnord Program
 Copyright 1997-1999 by Steve Jackson Games (http://www.sjgames.com/). 
 All Rights Reserved.

 Please read the README file for configuration and licensing info.

 The Fnorder was originally written for the Illuminati BBS by Steve
 Jackson and Creede Lambard.  It was later reimplemented in C by 
 Loyd Blankenship, and then converted to perl by Jackie Hamilton.
 Finally, Ian Gordon then converted the perl back to C.
 
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "fnord.h"


int random(int MAX) {
	return rand() % (MAX);
}

/* Delete last character of string */
void chop(char *str) {
	str[strlen(str)-1] = '\0';
}


char* p_intro() {
    return intros[random(sizeof(intros)/sizeof(*intros))];
}

char* p_noun() {
    return nouns[random(sizeof(nouns)/sizeof(*nouns))];
}

char* p_name() {
    return names[random(sizeof(names)/sizeof(*names))];
}

char* p_place() {
    return places[random(sizeof(places)/sizeof(*places))];
}

char* p_prs() {
    return prepositions[random(sizeof(prepositions)/sizeof(*prepositions))];
}

char* p_act() {
    return actions[random(sizeof(actions)/sizeof(*actions))];
}

char* p_pronoun() {
    return pronouns[random(sizeof(pronouns)/sizeof(*pronouns))];
}

char* p_adj() {
    return adjectives[random(sizeof(adjectives)/sizeof(*adjectives))];
}



/*
 * G L O B A L   V A R I A B L E S
 */
int syntax;
char msg[256] = "";


/*
 * M A I N  B L O C K
 */
int main()
{
	srand((unsigned int)time(NULL));

	syntax = random(13);
	
	// GRAMMAR RULES:
	// -----------------------------------

	if (syntax == 0)
	{
		strcat(msg,"The ");			// The
		if (random(2) > 0)
		{     // <adjective>  (50% chance)
			strcat(msg,p_adj());
		}
		strcat(msg,p_noun());		// <noun>
		if (random(5)==0)
		{	// in <someplace>   (20% chance)
			strcat(msg,"in ");
			strcat(msg,p_place());
		}
		strcat(msg,"is ");			// is
		strcat(msg,p_adj());		// <adjective>
	}

	else if (syntax == 1)
	{
		strcat(msg,p_name());		// <name>
		strcat(msg,p_act());		// <action>
		strcat(msg,"the ");			// the
		strcat(msg,p_adj());		// <adjective>
		strcat(msg,p_noun());		// <noun>
		strcat(msg,"and the ");		// and the
		strcat(msg,p_adj());		// <adjective>
		strcat(msg,p_noun());		// <noun>
	}

	else if (syntax == 2)
	{
		strcat(msg,"The ");			// The
		strcat(msg,p_noun());		// <noun>
		strcat(msg,"from ");		// from
		strcat(msg,p_place());		// <place>
		strcat(msg,"will go to ");	// will go to 
		strcat(msg,p_place());		// <place>
	}

	else if (syntax == 3)
	{
		strcat(msg,p_name());		// <name>
		strcat(msg,"must take the ");	// must take the
		strcat(msg,p_adj());		// <adjective>
		strcat(msg,p_noun());		// <noun>
		strcat(msg,"from ");		// from
		strcat(msg,p_place());		// <place>
	}

	else if (syntax == 4)
	{
		strcat(msg,p_place());		// <place>
		strcat(msg,"is ");			// is
		strcat(msg,p_adj());		// <adjective>
		strcat(msg,"and the ");		// and the
		strcat(msg,p_noun());		// <noun>
		strcat(msg,"is ");			// is
		strcat(msg,p_adj());		// <adjective>
	}

	else if (syntax == 5)
	{
		strcat(msg,p_name());		// <name>
		strcat(msg,p_prs());		// <preposition>
		strcat(msg,p_place());		// <place>
		strcat(msg,"for the ");		// for the
		strcat(msg,p_adj());		// <adjective>
		strcat(msg,p_noun());		// <noun>
	}

	else if (syntax == 6) 
	{
		strcat(msg,"The ");
		if (random(2) > 0)
		{
			strcat(msg,p_adj());	// <adjective> (50% chance)
		}
		strcat(msg,p_noun());		// <noun>
		strcat(msg,p_act());		// <action>
		strcat(msg,"the ");			// the
		strcat(msg,p_adj());		// <adjective>
		strcat(msg,p_noun());		// <noun>
		if (random(5)==0)
		{	// in <place>  (20% chance)
			strcat(msg,"in ");
			strcat(msg,p_place());
		}
	}

	else if (syntax == 7)
	{
		strcat(msg,p_name());		// <name>
		strcat(msg,p_prs());		// <preposition>
		strcat(msg,p_place());		// <place>
		strcat(msg,"and ");			// and
		strcat(msg,p_act());		// <action>
		strcat(msg,"the ");			// the
		strcat(msg,p_noun());		// <noun>
	}

	else if (syntax == 8)
	{
		strcat(msg,p_name());		// <name>
		strcat(msg,"takes ");		// takes
		strcat(msg,p_pronoun());	// <pronoun>
		if (random(2) > 0)
		{	      
			strcat(msg,p_adj());	// <adjective> (50% chance)
		}
		strcat(msg,p_noun());		// <noun>
		strcat(msg,"and ");			// and
		strcat(msg,p_prs());		// <preposition>
		strcat(msg,p_place());		// <place>
	}

	else if (syntax == 9)
	{
		strcat(msg,p_name());		// <name>
		strcat(msg,p_act());		// <action>
		strcat(msg,"the ");			// the
		if (random(2) > 0)
		{
			strcat(msg,p_adj());	// <adjective> (50% chance)
		}
		strcat(msg,p_noun());		// <noun>
	}

	else if (syntax == 10) 
	{
		strcat(msg,p_name());		// <name>
		strcat(msg,p_act());		// <action>
		strcat(msg,p_name());		// <name>
		strcat(msg,"and ");			// and
		strcat(msg,p_pronoun());	// <pronoun>
		if (random(2) > 0)
		{
			strcat(msg,p_adj());	// <adjective> (50% chance)
		}
		strcat(msg,p_noun());		// <noun>
	}

	else if (syntax == 11)
	{
		strcat(msg,p_name());		// <name>
		strcat(msg,"is the ");		// is the
		if (random(2) > 0)
		{
			strcat(msg,p_adj());	// <adjective) (50% chance)
		}			 
		strcat(msg,p_noun());		// <noun>
	    chop(msg);
		strcat(msg,"; ");			// ;
		strcat(msg,p_name());		// <name>
		strcat(msg,p_prs());		// <preposition>
		strcat(msg,p_place());		// <place>
	}

	else if (syntax == 12)
	{
		strcat(msg,"You must meet ");	// You must meet
		strcat(msg,p_name());		// <name>
		strcat(msg,"at ");			// at
		strcat(msg,p_place());		// <place>
		strcat(msg,"and get the ");	// and get the
		if (random(2) > 0)
		{
			strcat(msg,p_adj());	// <adjective> (50% chance)
		}
		strcat(msg,p_noun());		// <noun>
	}

	else 
	{
		strcat(msg,"A ");			// A
		strcat(msg,p_noun());		// <noun>
		strcat(msg,"from ");		// from
		strcat(msg,p_place());		// <place>
		strcat(msg,p_act());		// <action>
		strcat(msg,"the ");			// the
		if (random(2) > 0)
		{
			strcat(msg,p_adj());	// <adjective> (50% chance)
		}
		if (random(5) == 0)
		{
			strcat(msg,p_adj());	// <adjective> (20% chance)
		}
		strcat(msg,p_noun());		// <noun>
	}

	chop(msg);					// delete the blank at the end
	strcat(msg,".");			// add a period
	msg[0] = toupper(msg[0]);
	printf("%s\n",msg);			// print it out.

	// the end.
	return 0;
}